/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.interceptors;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.PartialBuildDefinition;
import com.atlassian.bamboo.fieldvalue.BuildDefinitionConverter;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bamboo.ww2.aware.BuildConfigurationAware;
import com.atlassian.bamboo.ww2.interceptors.AbstractBambooInterceptor;
import com.atlassian.bamboo.ww2.interceptors.PlanInterceptorUtils;
import com.opensymphony.xwork2.ActionInvocation;
import javax.inject.Inject;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;

public class BuildConfigurationEditInterceptor
extends AbstractBambooInterceptor {
    private static final Logger log = Logger.getLogger(BuildConfigurationEditInterceptor.class);
    @Inject
    private BuildDefinitionConverter buildDefinitionConverter;
    @Inject
    private PlanInterceptorUtils planInterceptorUtils;

    @Override
    public String doIntercept(ActionInvocation actionInvocation) throws Exception {
        Object action = actionInvocation.getAction();
        if (action instanceof BuildConfigurationAware) {
            BuildConfigurationAware buildConfigurationAware = (BuildConfigurationAware)action;
            if (buildConfigurationAware.getBuildConfiguration() == null) {
                log.debug((Object)"BuildConfiguration has not been set. Setting a new one.");
                ImmutablePlan plan = this.planInterceptorUtils.findPlan(this);
                if (plan != null) {
                    BuildDefinition buildDefinition = plan.getBuildDefinition();
                    XMLConfiguration configuration = this.buildDefinitionConverter.fromObject((PartialBuildDefinition)buildDefinition);
                    BuildConfiguration buildConfiguration = new BuildConfiguration((HierarchicalConfiguration)configuration);
                    buildConfigurationAware.setBuildConfiguration(buildConfiguration);
                    buildConfigurationAware.setPlan(plan);
                }
            } else {
                log.debug((Object)"BuildConfiguration has already been set.");
            }
        }
        return actionInvocation.invoke();
    }
}

