/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.interceptors;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.exception.XsrfCheckException;
import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.util.UrlUtils;
import com.atlassian.bamboo.utils.HttpUtils;
import com.atlassian.bamboo.ww2.interceptors.AbstractBambooInterceptor;
import com.atlassian.bamboo.ww2.interceptors.SecurityRelatedInterceptor;
import com.atlassian.http.mime.UserAgentUtil;
import com.atlassian.http.mime.UserAgentUtilImpl;
import com.opensymphony.xwork2.ActionInvocation;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SecurityRelatedInterceptor
public class BambooXsrfTokenInterceptor
extends AbstractBambooInterceptor {
    private static final Logger log = Logger.getLogger(BambooXsrfTokenInterceptor.class);
    public static final String XSRF_FAILURE_NO_REFERRER = "XSRF_FAILURE_NO_REFERRER";
    public static final String XSRF_FAILURE_BAD_REFERRER = "XSRF_FAILURE_BAD_REFERRER";
    public static final String XSRF_FAILURE_BAD_TOKEN = "XSRF_FAILURE_BAD_TOKEN";
    public static final String XSRF_FAILURE_NO_TOKEN_IN_COOKIE = "XSRF_FAILURE_NO_TOKEN_IN_COOKIE";
    public static final String XSRF_FAILURE_NO_TOKEN_IN_PARAMS = "XSRF_FAILURE_NO_TOKEN_IN_PARAMS";
    public static final String XSRF_SUCCESS = "XSRF_SUCCESS";
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;

    @Override
    public String doIntercept(ActionInvocation invocation) throws Exception {
        HttpServletRequest request = RequestCacheThreadLocal.getNonNullRequest();
        HttpServletResponse response = RequestCacheThreadLocal.getNonNullResponse();
        String existingCookieToken = XsrfTokenUtils.getOrCreateXsrfCookie(request, response);
        if (this.administrationConfigurationAccessor != null && !this.administrationConfigurationAccessor.getAdministrationConfiguration().isXsrfProtectionEnabled()) {
            return invocation.invoke();
        }
        Boolean isXsrfCheckEnabledForAction = this.getXsrfConfigurationForAction(invocation);
        if (Boolean.FALSE.equals(isXsrfCheckEnabledForAction)) {
            return invocation.invoke();
        }
        if (Boolean.TRUE.equals(isXsrfCheckEnabledForAction) || HttpUtils.canMethodMutateState((String)request.getMethod())) {
            String xsrfTokenSource;
            String xsrfCheckResult = this.doesRequestPassXsrfChecks(request, existingCookieToken);
            if (xsrfCheckResult != XSRF_SUCCESS) {
                log.warn((Object)("XSRF token validation failed in session:" + request.getRequestedSessionId() + " due to " + xsrfCheckResult));
                throw new XsrfCheckException("XSRF Token validation failed", xsrfCheckResult);
            }
            if (BuildUtils.isDevMode() && (xsrfTokenSource = XsrfTokenUtils.getXsrfTokenSource(request)) != null) {
                log.warn((Object)("Token for " + request.getRequestURI() + " had to be added by JavaScript fixup code"));
            }
        }
        return invocation.invoke();
    }

    @Nullable
    private Boolean getXsrfConfigurationForAction(ActionInvocation invocation) {
        String configParam = (String)invocation.getProxy().getConfig().getParams().get("RequireSecurityToken");
        if (configParam == null) {
            return null;
        }
        return Boolean.valueOf(configParam);
    }

    @NotNull
    private String doesRequestPassXsrfChecks(HttpServletRequest request, @Nullable String tokenFromCookie) {
        String referrer = request.getHeader("Referer");
        if (request.isSecure() && this.isABrowserUserAgent(request.getHeader("user-agent"))) {
            if (StringUtils.isBlank((CharSequence)referrer)) {
                return XSRF_FAILURE_NO_REFERRER;
            }
            if (!this.isReferrerInSameOrigin(referrer, request.getRequestURL().toString())) {
                if (log.isEnabledFor((Priority)Level.WARN)) {
                    String message = String.format("XSRF isReferrerInSameOrigin check failed in session:%s as the referer %s is not in the same origin as %s .", request.getRequestedSessionId(), StringUtils.substringBefore((String)referrer, (String)"?"), StringUtils.substringBefore((String)request.getRequestURL().toString(), (String)"?"));
                    log.warn((Object)message);
                }
                return XSRF_FAILURE_BAD_REFERRER;
            }
        }
        if (BambooXsrfTokenInterceptor.isOverrideHeaderPresent(request)) {
            return XSRF_SUCCESS;
        }
        if (tokenFromCookie == null) {
            return XSRF_FAILURE_NO_TOKEN_IN_COOKIE;
        }
        String tokenFromParams = XsrfTokenUtils.getTokenFromRequestParameters(request);
        if (tokenFromParams == null) {
            return XSRF_FAILURE_NO_TOKEN_IN_PARAMS;
        }
        return StringUtils.equals((CharSequence)tokenFromParams, (CharSequence)tokenFromCookie) ? XSRF_SUCCESS : XSRF_FAILURE_BAD_TOKEN;
    }

    private boolean isReferrerInSameOrigin(String referrer, String requestURL) {
        return UrlUtils.isSameOrigin((URL)UrlUtils.createUrl((String)referrer), (URL)UrlUtils.createUrl((String)requestURL));
    }

    private boolean isABrowserUserAgent(String userAgent) {
        UserAgentUtil.BrowserFamily browserFamily = new UserAgentUtilImpl().getBrowserFamily(userAgent);
        return !browserFamily.equals((Object)UserAgentUtil.BrowserFamily.UKNOWN);
    }

    private static boolean isOverrideHeaderPresent(HttpServletRequest request) {
        return "no-check".equals(request.getHeader("X-Atlassian-Token"));
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }
}

