/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.interceptors;

import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.ww2.aware.BypassValidationAware;
import com.atlassian.struts.ValidationAware;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.DefaultWorkflowInterceptor;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;

public class BambooWorkflowInterceptor
extends DefaultWorkflowInterceptor {
    private static final Logger log = Logger.getLogger(BambooWorkflowInterceptor.class);

    public String doIntercept(ActionInvocation actionInvocation) throws Exception {
        try (Ticker ignored = Timers.start((String)(((Object)((Object)this)).getClass().getName() + ".intercept"));){
            String string = this.validateWorkflow(actionInvocation);
            return string;
        }
    }

    private String validateWorkflow(ActionInvocation actionInvocation) throws Exception {
        BypassValidationAware bypassValidationAware;
        Object action = actionInvocation.getAction();
        if (action instanceof BypassValidationAware && (bypassValidationAware = (BypassValidationAware)action).isValidationBypassed()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Back button pressed. Bypassing workflow validation for " + actionInvocation.getProxy().getNamespace() + "/" + actionInvocation.getProxy().getActionName() + " with method " + actionInvocation.getProxy().getMethod() + "."));
            }
            return actionInvocation.invoke();
        }
        String result = super.doIntercept(actionInvocation);
        ValidationAware validationAwareAction = (ValidationAware)Narrow.downTo((Object)action, ValidationAware.class);
        if (validationAwareAction != null && validationAwareAction.hasErrors()) {
            Map fieldErrors = validationAwareAction.getFieldErrors();
            if (log.isDebugEnabled()) {
                log.debug((Object)(fieldErrors.size() + " field errors found..."));
                for (Map.Entry o : fieldErrors.entrySet()) {
                    log.debug((Object)("* " + o.getKey() + ": " + o.getValue()));
                }
                Collection actionErrors = validationAwareAction.getActionErrors();
                log.debug((Object)(actionErrors.size() + " action errors found..."));
                for (Object o : actionErrors) {
                    log.debug((Object)("* " + o));
                }
            }
        }
        return result;
    }
}

