/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.common;

import com.atlassian.bamboo.utils.BambooPredicates;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class JsonHelper {
    private static final Logger log = Logger.getLogger(JsonHelper.class);
    private static final Pattern PROPERTY_GETTER_NAME_PATTERN = Pattern.compile("(get|is)([A-Z].*)");

    private JsonHelper() {
    }

    public static void returnJsonResponse(HttpServletResponse response, JSONObject json) throws JSONException, IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        response.setStatus(200);
        json.write((Writer)response.getWriter());
    }

    @NotNull
    public static JSONObject buildJsonObject(Object bean, String ... properties) {
        return JsonHelper.buildJsonObject(bean, Sets.newHashSet((Object[])properties));
    }

    @NotNull
    public static JSONObject buildJsonObject(Object bean, Iterable<String> properties) {
        JSONObject result = new JSONObject();
        for (Method method : Iterables.filter(Arrays.asList(bean.getClass().getMethods()), (Predicate)BambooPredicates.methodHasNoArguments())) {
            String propertyKey;
            Matcher matcher = PROPERTY_GETTER_NAME_PATTERN.matcher(method.getName());
            if (!matcher.matches() || !Iterables.contains(properties, (Object)(propertyKey = StringUtils.uncapitalize((String)matcher.group(2))))) continue;
            try {
                result.put(propertyKey, method.invoke(bean, new Object[0]));
            }
            catch (Exception exception) {}
        }
        return result;
    }
}

