/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.beans.author;

import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.author.ExtendedAuthorManager;
import com.atlassian.bamboo.ww2.beans.author.DecoratedPersonaBuildStatistics;
import com.atlassian.user.User;
import com.google.common.base.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DecoratedUserBuildStatistics
implements DecoratedPersonaBuildStatistics {
    private static final Logger log = Logger.getLogger(DecoratedUserBuildStatistics.class);
    private final String name;
    private final String nameDisplayUrl;
    private final long numberOfTriggeredBuilds;
    private final long numberOfFailedBuilds;
    private final double percentageOfFailedBuilds;
    private final long numberOfBrokenBuilds;
    private final long numberOfFixedBuilds;
    private final long score;

    public DecoratedUserBuildStatistics(@NotNull User user, @NotNull ExtendedAuthorManager extendedAuthorManager) {
        this.name = (String)StringUtils.defaultIfEmpty((CharSequence)user.getFullName(), (CharSequence)user.getName());
        this.nameDisplayUrl = String.format("browse/user/%s", StringEscapeUtils.escapeHtml4((String)user.getName()));
        long triggered = 0L;
        long failed = 0L;
        long breakages = 0L;
        long fixes = 0L;
        for (ExtendedAuthor author : extendedAuthorManager.getLinkedAuthorForUser(user)) {
            triggered += (long)author.getNumberOfTriggeredBuilds();
            failed += (long)author.getNumberOfFailedBuilds();
            breakages += (long)author.getNumberOfBreakages();
            fixes += (long)author.getNumberOfFixes();
        }
        this.numberOfTriggeredBuilds = triggered;
        this.numberOfFailedBuilds = failed;
        this.percentageOfFailedBuilds = this.numberOfTriggeredBuilds > 0L ? (double)this.numberOfFailedBuilds / (double)this.numberOfTriggeredBuilds : 0.0;
        this.numberOfBrokenBuilds = breakages;
        this.numberOfFixedBuilds = fixes;
        this.score = this.numberOfFixedBuilds - this.numberOfBrokenBuilds;
    }

    public static Function<User, DecoratedUserBuildStatistics> createFromUser(@NotNull ExtendedAuthorManager extendedAuthorManager) {
        return user -> new DecoratedUserBuildStatistics((User)user, extendedAuthorManager);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameDisplayUrl() {
        return this.nameDisplayUrl;
    }

    @Override
    public long getNumberOfTriggeredBuilds() {
        return this.numberOfTriggeredBuilds;
    }

    @Override
    public long getNumberOfFailedBuilds() {
        return this.numberOfFailedBuilds;
    }

    @Override
    public double getPercentageOfFailedBuilds() {
        return this.percentageOfFailedBuilds;
    }

    @Override
    public long getNumberOfBrokenBuilds() {
        return this.numberOfBrokenBuilds;
    }

    @Override
    public long getNumberOfFixedBuilds() {
        return this.numberOfFixedBuilds;
    }

    @Override
    public long getScore() {
        return this.score;
    }
}

