/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.beans.author;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.ww2.beans.author.DecoratedPersonaBuildStatistics;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;

public class DecoratedAuthorBuildStatistics
implements DecoratedPersonaBuildStatistics {
    private final String name;
    private final String nameDisplayUrl;
    private final long numberOfTriggeredBuilds;
    private final long numberOfFailedBuilds;
    private final double percentageOfFailedBuilds;
    private final long numberOfBrokenBuilds;
    private final long numberOfFixedBuilds;
    private final long score;

    public DecoratedAuthorBuildStatistics(@NotNull Author author) {
        String linkedUserName = author.getLinkedUserName();
        if (linkedUserName != null) {
            this.name = String.format("%s (%s)", author.getName(), author.getFullName());
            this.nameDisplayUrl = String.format("users/viewUserSummary.action?currentUserName=%s", StringEscapeUtils.escapeHtml4((String)linkedUserName));
        } else {
            this.name = author.getName();
            this.nameDisplayUrl = String.format("authors/viewAuthor.action?authorName=%s", StringEscapeUtils.escapeHtml4((String)author.getName()));
        }
        this.numberOfTriggeredBuilds = author.getNumberOfTriggeredBuilds();
        this.numberOfFailedBuilds = author.getNumberOfFailedBuilds();
        this.percentageOfFailedBuilds = this.numberOfTriggeredBuilds > 0L ? (double)this.numberOfFailedBuilds / (double)this.numberOfTriggeredBuilds : 0.0;
        this.numberOfBrokenBuilds = author.getNumberOfBreakages();
        this.numberOfFixedBuilds = author.getNumberOfFixes();
        this.score = this.numberOfFixedBuilds - this.numberOfBrokenBuilds;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameDisplayUrl() {
        return this.nameDisplayUrl;
    }

    @Override
    public long getNumberOfBrokenBuilds() {
        return this.numberOfBrokenBuilds;
    }

    @Override
    public long getNumberOfFailedBuilds() {
        return this.numberOfFailedBuilds;
    }

    @Override
    public long getNumberOfFixedBuilds() {
        return this.numberOfFixedBuilds;
    }

    @Override
    public long getNumberOfTriggeredBuilds() {
        return this.numberOfTriggeredBuilds;
    }

    @Override
    public double getPercentageOfFailedBuilds() {
        return this.percentageOfFailedBuilds;
    }

    @Override
    public long getScore() {
        return this.score;
    }
}

