/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.beans;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.ww2.beans.DecoratedNavGroupStatus;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.xwork2.TextProvider;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DecoratedStageStatus
implements DecoratedNavGroupStatus {
    private static final Logger log = Logger.getLogger(DecoratedStageStatus.class);
    private final LifeCycleState lifeCycleState;
    private final BuildState buildState;
    private final int totalBuildResults;
    private final int failedBuildResults;
    private final int succesfulBuildResults;
    private TextProvider textProvider;

    DecoratedStageStatus(ChainStageResult stageResult) {
        this.lifeCycleState = stageResult.getLifeCycleState();
        this.buildState = stageResult.getState();
        this.totalBuildResults = stageResult.getBuildResults().size();
        this.failedBuildResults = stageResult.getFailedBuildResults().size();
        this.succesfulBuildResults = stageResult.getSuccessfulBuildResults().size();
    }

    @Override
    @NotNull
    public String getDisplayClass() {
        return this.lifeCycleState.equals((Object)LifeCycleState.FINISHED) ? this.buildState.toString() : this.lifeCycleState.toString();
    }

    @NotNull
    public String getDisplayMessageForStage() {
        String stageStatus = this.totalBuildResults > 0 ? (LifeCycleState.FINISHED == this.lifeCycleState ? (BuildState.FAILED == this.buildState ? this.getTextProvider().getText("stage.status.failed.description", Arrays.asList(this.failedBuildResults, this.totalBuildResults)) : (BuildState.SUCCESS == this.buildState ? this.getTextProvider().getText("stage.status.success.description", Arrays.asList(this.totalBuildResults)) : this.getTextProvider().getText("stage.status.notBuilt.description", Arrays.asList(this.totalBuildResults - this.succesfulBuildResults, this.totalBuildResults)))) : (LifeCycleState.NOT_BUILT == this.lifeCycleState ? this.getTextProvider().getText("stage.status.notBuilt.description", Arrays.asList(this.totalBuildResults - this.succesfulBuildResults, this.totalBuildResults)) : (LifeCycleState.PENDING == this.lifeCycleState ? this.getTextProvider().getText("stage.status.pending.description", Arrays.asList(this.totalBuildResults)) : this.getTextProvider().getText("stage.status.inProgress.description", Arrays.asList(this.totalBuildResults))))) : this.getTextProvider().getText("stage.status.noJobs.description");
        return stageStatus;
    }

    private TextProvider getTextProvider() {
        if (this.textProvider == null) {
            this.textProvider = (TextProvider)ContainerManager.getComponent((String)"textProvider");
        }
        return this.textProvider;
    }
}

