/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.beans;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.ww2.beans.DecoratedNavGroupObject;
import com.atlassian.bamboo.ww2.beans.DecoratedNavGroupStatus;
import com.atlassian.bamboo.ww2.beans.DecoratedNavObject;
import com.atlassian.bamboo.ww2.beans.DecoratedNavObjectFactory;
import com.atlassian.bamboo.ww2.beans.DecoratedNavObjectFunctions;
import com.atlassian.bamboo.ww2.beans.DecoratedPlan;
import com.atlassian.bamboo.ww2.beans.DecoratedResult;
import com.atlassian.bamboo.ww2.beans.DecoratedStage;
import com.atlassian.bamboo.ww2.beans.DecoratedStageStatus;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import javax.annotation.concurrent.Immutable;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class DecoratedStageResult
implements DecoratedNavGroupObject {
    private static final Logger log = Logger.getLogger(DecoratedStageResult.class);
    private final long stageResultId;
    private final String stageName;
    private final String stageDescription;
    private final String planKey;
    private final boolean manual;
    private final boolean finalStage;
    private final boolean runnable;
    private final boolean restartable;
    private final String continueStageUrl;
    private final String restartStageUrl;
    private final ImmutableList<DecoratedResult> jobResults;
    private final DecoratedStageStatus status;

    DecoratedStageResult(ChainStageResult stageResult, DecoratedResult parent, @NotNull DecoratedPlan decoratedChain, @NotNull DecoratedNavObjectFactory decoratedNavObjectFactory) {
        this.stageResultId = stageResult.getId();
        this.stageName = stageResult.getName();
        this.stageDescription = stageResult.getDescription();
        this.planKey = decoratedChain.getPlanKey().getKey();
        this.manual = stageResult.isManual();
        this.finalStage = stageResult.isFinal();
        this.runnable = stageResult.isRunnable();
        this.restartable = stageResult.isRestartable();
        ChainResultsSummary chainResult = stageResult.getChainResult();
        this.continueStageUrl = "/ajax/editParameterisedManualBuild.action?planKey=" + chainResult.getImmutablePlan().getKey() + "&buildNumber=" + chainResult.getBuildNumber() + "&stageToContinue=" + stageResult.getName();
        this.restartStageUrl = "/build/admin/restartBuild.action?planKey=" + chainResult.getImmutablePlan().getKey() + "&buildNumber=" + chainResult.getBuildNumber();
        ArrayList<DecoratedResult> mutableJobs = new ArrayList<DecoratedResult>();
        DecoratedStage decoratedStage = decoratedChain.getStageWithName(this.stageName);
        if (decoratedStage == null) {
            log.debug((Object)("Could not find stage with name " + this.stageName + " although result for build " + parent.getBuildNumber() + " exists."));
            decoratedStage = (DecoratedStage)decoratedNavObjectFactory.getStageResultDecorator(decoratedChain).apply((Object)stageResult);
        }
        for (BuildResultsSummary jobResult : stageResult.getBuildResults()) {
            if (jobResult.isMarkedForDeletion()) continue;
            DecoratedPlan decoratedJob = decoratedStage.getJobWithKey(jobResult.getPlanKey());
            if (decoratedJob == null) {
                log.debug((Object)("Could not find job with key " + jobResult.getPlanKey() + " although result for build " + parent.getBuildNumber() + " exists."));
                decoratedJob = DecoratedPlan.decorateJobResult(decoratedChain, jobResult);
            }
            mutableJobs.add(DecoratedResult.decorateJobResult(jobResult, parent, decoratedJob));
        }
        this.jobResults = DecoratedNavObjectFunctions.decoratedNavObjectDisplayNameOrdering().immutableSortedCopy(mutableJobs);
        this.status = new DecoratedStageStatus(stageResult);
    }

    @Override
    public long getId() {
        return this.stageResultId;
    }

    @Override
    @NotNull
    public String getName() {
        return this.stageName;
    }

    public String getPlanKey() {
        return this.planKey;
    }

    public boolean isManual() {
        return this.manual;
    }

    public boolean isFinal() {
        return this.finalStage;
    }

    public boolean isRunnable() {
        return this.runnable;
    }

    public boolean isRestartable() {
        return this.restartable;
    }

    public String getContinueUrl() {
        return this.continueStageUrl;
    }

    public String getRestartUrl() {
        return this.restartStageUrl;
    }

    @Override
    @Nullable
    public ImmutableList<? extends DecoratedNavObject> getChildren() {
        return this.jobResults;
    }

    @Override
    @Nullable
    public DecoratedNavGroupStatus getStatus() {
        return this.status;
    }

    @Override
    public String getDescription() {
        return this.stageDescription;
    }

    @Override
    public String getGroupSummary() {
        return this.status.getDisplayMessageForStage();
    }

    public ImmutableList<DecoratedResult> getBuildResults() {
        return this.jobResults;
    }
}

