/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.beans;

import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.ww2.beans.DecoratedNavGroupObject;
import com.atlassian.bamboo.ww2.beans.DecoratedNavGroupStatus;
import com.atlassian.bamboo.ww2.beans.DecoratedNavObject;
import com.atlassian.bamboo.ww2.beans.DecoratedNavObjectFunctions;
import com.atlassian.bamboo.ww2.beans.DecoratedPlan;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.opensymphony.xwork2.TextProvider;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class DecoratedStage
implements DecoratedNavGroupObject {
    private static final Logger log = Logger.getLogger(DecoratedStage.class);
    private final long stageId;
    private final String stageName;
    private final String description;
    private final String planKey;
    private final boolean manual;
    private final boolean finalStage;
    private final ImmutableList<DecoratedPlan> jobs;
    private final String groupSummary;

    DecoratedStage(@NotNull TextProvider textProvider, @NotNull ImmutableChainStage stage, @NotNull Iterable<DecoratedPlan> jobs) {
        this.stageId = stage.getId();
        this.stageName = stage.getName();
        this.description = stage.getDescription();
        this.planKey = stage.getChain().getPlanKey().getKey();
        this.manual = stage.isManual();
        this.finalStage = stage.isFinal();
        this.jobs = DecoratedNavObjectFunctions.decoratedNavObjectDisplayNameOrdering().immutableSortedCopy(jobs);
        this.groupSummary = textProvider.getText("stage.status.numberOfJobs.description", Collections.singletonList(Iterables.size(jobs)));
    }

    DecoratedStage(@NotNull TextProvider textProvider, @NotNull ChainStageResult stageResult, @NotNull Iterable<DecoratedPlan> jobs) {
        this.stageId = stageResult.getId();
        this.stageName = stageResult.getName();
        this.description = stageResult.getDescription();
        this.planKey = stageResult.getChainResult().getPlanResultKey().getPlanKey().getKey();
        this.manual = stageResult.isManual();
        this.finalStage = stageResult.isFinal();
        this.jobs = DecoratedNavObjectFunctions.decoratedNavObjectDisplayNameOrdering().immutableSortedCopy(jobs);
        this.groupSummary = textProvider.getText("stage.status.numberOfJobs.description", Collections.singletonList(Iterables.size(jobs)));
    }

    @Override
    public long getId() {
        return this.stageId;
    }

    @Override
    @NotNull
    public String getName() {
        return this.stageName;
    }

    @Override
    @Nullable
    public ImmutableList<? extends DecoratedNavObject> getChildren() {
        return this.jobs;
    }

    @Override
    @Nullable
    public DecoratedNavGroupStatus getStatus() {
        return null;
    }

    @Override
    public String getGroupSummary() {
        return this.groupSummary;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getPlanKey() {
        return this.planKey;
    }

    public boolean isManual() {
        return this.manual;
    }

    public boolean isFinal() {
        return this.finalStage;
    }

    public List<DecoratedPlan> getJobs() {
        return this.jobs;
    }

    @Nullable
    public DecoratedPlan getJobWithKey(@NotNull PlanKey planKey) {
        for (DecoratedPlan decoratedPlan : this.getJobs()) {
            if (!decoratedPlan.getPlanKey().getPartialKey().equals(planKey.getPartialKey())) continue;
            return decoratedPlan;
        }
        return null;
    }
}

