/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.beans;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.plan.ExecutionStatus;
import com.atlassian.bamboo.plan.PlanExecutionManager;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultSummaryHelper;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.utils.DurationUtils;
import com.atlassian.bamboo.ww2.beans.DecoratedNavObjectStatus;
import com.atlassian.bamboo.ww2.beans.DecoratedResult;
import com.google.common.base.Optional;
import com.opensymphony.xwork2.TextProvider;
import io.atlassian.util.concurrent.Lazy;
import java.util.Date;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecoratedResultStatus
implements DecoratedNavObjectStatus {
    private static final Logger log = Logger.getLogger(DecoratedResultStatus.class);
    public static final String NOT_RUN_YET = "NotRunYet";
    private final LifeCycleState lifeCycleState;
    private final BuildState buildState;
    private final boolean isSpecsResult;
    private final boolean specsFailure;
    private final boolean specsSuccess;
    private final String testSummary;
    private final String duration;
    private final Date buildStartTime;
    private final Date queuedTime;
    private final Long vcsUpdateDuration;
    private final boolean notRunYet;
    private final boolean continuable;
    private final Supplier<Optional<ExecutionStatus>> executionStatus = Lazy.supplier((Supplier)new Supplier<Optional<ExecutionStatus>>(){

        @Override
        public Optional<ExecutionStatus> get() {
            return Optional.fromNullable((Object)((PlanExecutionManager)ComponentAccessor.PLAN_EXECUTION_MANAGER.get()).getExecutionStatus(DecoratedResultStatus.this.decoratedResult.getPlanResultKey()));
        }
    });
    private final DecoratedResult decoratedResult;

    public DecoratedResultStatus(ResultsSummary resultSummary, DecoratedResult decoratedResult) {
        this.lifeCycleState = resultSummary.getLifeCycleState();
        this.buildState = resultSummary.getBuildState();
        this.isSpecsResult = ResultSummaryHelper.isBambooSpecResult((ImmutableResultsSummary)resultSummary);
        this.specsFailure = ResultSummaryHelper.isBambooSpecFailure((ImmutableResultsSummary)resultSummary);
        this.specsSuccess = ResultSummaryHelper.isBambooSpecSuccess((ImmutableResultsSummary)resultSummary);
        this.testSummary = resultSummary.getTestSummary();
        this.duration = resultSummary.getProcessingDurationDescription();
        this.decoratedResult = decoratedResult;
        this.buildStartTime = resultSummary.getBuildDate();
        this.queuedTime = resultSummary.getQueueTime();
        this.vcsUpdateDuration = resultSummary instanceof BuildResultsSummary ? Long.valueOf(((BuildResultsSummary)resultSummary).getVcsUpdateDuration()) : null;
        this.notRunYet = resultSummary.isNotRunYet();
        this.continuable = resultSummary instanceof ChainResultsSummary && ((ChainResultsSummary)resultSummary).isContinuable();
    }

    @Override
    @NotNull
    public String getDisplayClass() {
        if (this.notRunYet) {
            return NOT_RUN_YET;
        }
        return LifeCycleState.isFinalized((LifeCycleState)this.lifeCycleState) ? this.buildState.toString() : this.lifeCycleState.toString();
    }

    @Override
    @NotNull
    public String getJobExecutionPhaseString() {
        if (this.isUpdatingSource()) {
            return "updatingSource";
        }
        return this.getDisplayClass();
    }

    @Override
    @Nullable
    public ExecutionStatus getExecutionStatus() {
        return (ExecutionStatus)this.executionStatus.get().orNull();
    }

    @Override
    public boolean isInProgress() {
        return LifeCycleState.isInProgress((LifeCycleState)this.lifeCycleState);
    }

    @Override
    public boolean isActive() {
        return LifeCycleState.isActive((LifeCycleState)this.lifeCycleState);
    }

    @Override
    public boolean isUpdatingSource() {
        return LifeCycleState.isInProgress((LifeCycleState)this.lifeCycleState) && this.buildStartTime == null;
    }

    @Override
    public String getTestSummary() {
        return this.testSummary;
    }

    @Override
    public String getDuration() {
        return this.duration;
    }

    public Date getBuildStartTime() {
        return this.buildStartTime;
    }

    public boolean isContinuable() {
        return this.continuable;
    }

    public boolean isNotRunYet() {
        return this.notRunYet;
    }

    @Override
    @NotNull
    public String getSummarySuffix() {
        if (LifeCycleState.isPending((LifeCycleState)this.lifeCycleState)) {
            return this.getTextProvider().getText("buildResult.summary.status.waiting.suffix");
        }
        if (LifeCycleState.isQueued((LifeCycleState)this.lifeCycleState)) {
            return this.getTextProvider().getText("buildResult.summary.status.queued.suffix");
        }
        if (LifeCycleState.isInProgress((LifeCycleState)this.lifeCycleState)) {
            if (this.buildStartTime != null) {
                return this.getTextProvider().getText("buildResult.summary.status.inProgress.suffix");
            }
            return this.getTextProvider().getText("buildResult.summary.status.updatingSource.suffix");
        }
        if (LifeCycleState.isFinished((LifeCycleState)this.lifeCycleState)) {
            if (BuildState.SUCCESS == this.buildState) {
                return this.getTextProvider().getText("buildResult.summary.status.finished.successful.suffix");
            }
            return this.getTextProvider().getText("buildResult.summary.status.finished.failed.suffix");
        }
        if (LifeCycleState.isNotBuilt((LifeCycleState)this.lifeCycleState)) {
            if (this.decoratedResult.getBuildDate() == null) {
                return this.getTextProvider().getText("buildResult.summary.status.notStarted.suffix");
            }
            return this.getTextProvider().getText("buildResult.summary.status.notBuilt.suffix");
        }
        return "";
    }

    @Override
    @Nullable
    public String getOpTimeText() {
        if (LifeCycleState.isQueued((LifeCycleState)this.lifeCycleState)) {
            return this.getPrettyQueuedTime();
        }
        if (!LifeCycleState.isInProgress((LifeCycleState)this.lifeCycleState)) {
            return null;
        }
        ExecutionStatus executionStatus = (ExecutionStatus)this.executionStatus.get().orNull();
        if (executionStatus == null) {
            return null;
        }
        if (this.buildStartTime != null) {
            if (executionStatus.getAverageDuration() > 0L) {
                return "&ndash; " + executionStatus.getProgressBar().getPrettyTimeRemaining(false);
            }
            return "&ndash; " + DurationUtils.getPrettyPrint((long)executionStatus.getElapsedTime(), (boolean)false);
        }
        return this.getPrettyVcsUpdateDuration();
    }

    private TextProvider getTextProvider() {
        return (TextProvider)ComponentAccessor.TEXT_PROVIDER.get();
    }

    public LifeCycleState getLifeCycleState() {
        return this.lifeCycleState;
    }

    public BuildState getBuildState() {
        return this.buildState;
    }

    @Override
    public boolean isSpecsResult() {
        return this.isSpecsResult;
    }

    @Override
    public boolean isSpecsFailure() {
        return this.specsFailure;
    }

    @Override
    public boolean isSpecsSuccess() {
        return this.specsSuccess;
    }

    private String getPrettyVcsUpdateDuration() {
        if (this.vcsUpdateDuration != null) {
            return DurationUtils.getPrettyPrint((long)this.vcsUpdateDuration, (boolean)true);
        }
        return "";
    }

    private String getPrettyQueuedTime() {
        if (this.queuedTime != null) {
            return DurationUtils.getPrettyPrint((long)DurationUtils.getElapsedTime((Date)this.queuedTime));
        }
        return "";
    }
}

