/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.beans;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.PlanType;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.ww2.beans.DecoratedNavGroupObject;
import com.atlassian.bamboo.ww2.beans.DecoratedNavObject;
import com.atlassian.bamboo.ww2.beans.DecoratedNavObjectFactory;
import com.atlassian.bamboo.ww2.beans.DecoratedNavObjectStatus;
import com.atlassian.bamboo.ww2.beans.DecoratedPlan;
import com.atlassian.bamboo.ww2.beans.DecoratedResultStatus;
import com.atlassian.bamboo.ww2.beans.DecoratedStageResult;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DecoratedResult
implements DecoratedNavObject {
    private final DecoratedPlan decoratedPlan;
    private final PlanResultKey planResultKey;
    private final Date buildDate;
    private final DecoratedResultStatus status;

    @Nullable
    public static DecoratedResult decorateChainResult(@NotNull ChainResultsSummary resultsSummary, @NotNull DecoratedPlan decoratedPlan, @NotNull DecoratedNavObjectFactory decoratedNavObjectFactory) {
        return new DecoratedChainResult(resultsSummary, decoratedPlan, decoratedNavObjectFactory);
    }

    @NotNull
    static DecoratedResult decorateJobResult(@NotNull BuildResultsSummary resultsSummary, @NotNull DecoratedResult parentResult, @NotNull DecoratedPlan decoratedPlan) {
        return new DecoratedJobResult((ResultsSummary)resultsSummary, parentResult, decoratedPlan);
    }

    private DecoratedResult(@NotNull ResultsSummary chainResult, @NotNull DecoratedPlan decoratedPlan) {
        this.planResultKey = chainResult.getPlanResultKey();
        this.decoratedPlan = decoratedPlan;
        this.status = new DecoratedResultStatus(chainResult, this);
        this.buildDate = chainResult.getBuildDate();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.planResultKey.getKey();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.decoratedPlan.getDisplayName();
    }

    @Override
    @NotNull
    public ImmutableList<? extends DecoratedNavGroupObject> getNavGroups() {
        return this.getStageResults();
    }

    @Override
    @Nullable
    public abstract DecoratedResult getParent();

    @Override
    @NotNull
    public PlanType getPlanType() {
        return this.decoratedPlan.getPlanType();
    }

    @Override
    @Nullable
    public PlanIdentifier getMaster() {
        return this.decoratedPlan.getMaster();
    }

    public String getDescription() {
        return this.decoratedPlan.getDescription();
    }

    @Override
    @NotNull
    public String getType() {
        return this.decoratedPlan.getPlanType().name();
    }

    @Override
    @Nullable
    public DecoratedNavObjectStatus getStatus() {
        return this.status;
    }

    @Override
    public boolean isResult() {
        return true;
    }

    @Nullable
    public ImmutableList<DecoratedPlan.DecoratedPlanBranchGist> getBranches() {
        return this.decoratedPlan.getBranches();
    }

    @Override
    @Nullable
    public String replaceKey(String url, DecoratedNavObject originalObject) {
        DecoratedResult originalResult = (DecoratedResult)Narrow.to((Object)originalObject, DecoratedResult.class);
        if (originalResult != null) {
            if (url.contains(originalResult.getKey())) {
                return url.replaceAll(originalResult.getKey(), this.getKey());
            }
            if (url.contains(originalResult.getPlanKey() + "/latestSuccessful")) {
                return url.replaceAll(originalResult.getPlanKey() + "/latestSuccessful", this.getKey());
            }
            if (url.contains(originalResult.getPlanKey() + "/latest")) {
                return url.replaceAll(originalResult.getPlanKey() + "/latest", this.getKey());
            }
            if (url.contains(originalResult.getPlanKey())) {
                return url.replaceAll(originalResult.getPlanKey(), this.getPlanKey());
            }
            String newUrl = url.replaceAll("\\$\\{planKey\\}", this.getPlanKey());
            newUrl = newUrl.replaceAll("\\$\\{buildNumber\\}", Integer.toString(this.planResultKey.getBuildNumber()));
            return newUrl;
        }
        return null;
    }

    public String getPlanKey() {
        return this.planResultKey.getPlanKey().getKey();
    }

    public int getBuildNumber() {
        return this.planResultKey.getBuildNumber();
    }

    public PlanResultKey getPlanResultKey() {
        return this.planResultKey;
    }

    public String getProjectKey() {
        return this.decoratedPlan.getProject().getKey();
    }

    public String getProjectName() {
        return this.decoratedPlan.getProject().getName();
    }

    public String getFullName() {
        return this.decoratedPlan.getName();
    }

    public abstract ImmutableList<DecoratedStageResult> getStageResults();

    public Date getBuildDate() {
        return this.buildDate;
    }

    @Nullable
    public String getBranchName() {
        return this.decoratedPlan.getBranchName();
    }

    @Nullable
    public String getLinkedJiraIssue() {
        return this.decoratedPlan.getLinkedJiraIssue();
    }

    public boolean isRemoteJiraLinkRequired() {
        return this.decoratedPlan.isRemoteJiraLinkRequired();
    }

    public boolean isSuspendedFromBuilding() {
        return this.decoratedPlan.isSuspendedFromBuilding();
    }

    private static class DecoratedJobResult
    extends DecoratedResult {
        private final DecoratedResult parentResult;

        DecoratedJobResult(@NotNull ResultsSummary resultsSummary, @NotNull DecoratedResult parentResult, @NotNull DecoratedPlan decoratedPlan) {
            super(resultsSummary, decoratedPlan);
            this.parentResult = parentResult;
        }

        @Override
        @Nullable
        public DecoratedResult getParent() {
            return this.parentResult;
        }

        @Override
        public ImmutableList<DecoratedStageResult> getStageResults() {
            return null;
        }
    }

    private static class DecoratedChainResult
    extends DecoratedResult {
        private final ImmutableList<DecoratedStageResult> stageResults;

        DecoratedChainResult(ChainResultsSummary chainResult, DecoratedPlan decoratedPlan, DecoratedNavObjectFactory decoratedNavObjectFactory) {
            super((ResultsSummary)chainResult, decoratedPlan);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ChainStageResult stageResult : chainResult.getStageResults()) {
                builder.add((Object)new DecoratedStageResult(stageResult, this, decoratedPlan, decoratedNavObjectFactory));
            }
            this.stageResults = builder.build();
        }

        @Override
        @Nullable
        public DecoratedResult getParent() {
            return null;
        }

        @Override
        public ImmutableList<DecoratedStageResult> getStageResults() {
            return this.stageResults;
        }
    }
}

