/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.beans;

import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanIdentifierImpl;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanType;
import com.atlassian.bamboo.plan.branch.ChainBranchIdentifier;
import com.atlassian.bamboo.plan.branch.ChainBranchIdentifierImpl;
import com.atlassian.bamboo.plan.branch.PlanBranchWorkflow;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.PlanBranchGist;
import com.atlassian.bamboo.project.ProjectIdentifier;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.ww2.beans.DecoratedNavGroupObject;
import com.atlassian.bamboo.ww2.beans.DecoratedNavObject;
import com.atlassian.bamboo.ww2.beans.DecoratedNavObjectFactory;
import com.atlassian.bamboo.ww2.beans.DecoratedNavObjectStatus;
import com.atlassian.bamboo.ww2.beans.DecoratedStage;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.atlassian.util.concurrent.Lazy;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public abstract class DecoratedPlan
implements DecoratedNavObject,
PlanIdentifier {
    private final PlanIdentifier planIdentifier;
    private ImmutableList<String> labelNames;

    static DecoratedPlan decorateChain(@NotNull DecoratedNavObjectFactory decoratedNavObjectFactory, @NotNull ImmutableChain chain, @NotNull List<DeploymentProject> deploymentProjects) {
        return new DecoratedChain(decoratedNavObjectFactory, chain, deploymentProjects);
    }

    static DecoratedPlan decorateJob(@NotNull DecoratedPlan parent, @NotNull ImmutablePlan plan) {
        return new DecoratedJob(parent, plan);
    }

    static DecoratedPlan decorateJobResult(@NotNull DecoratedPlan parent, @NotNull BuildResultsSummary resultsSummary) {
        return new DecoratedJob(parent, resultsSummary);
    }

    static DecoratedPlan decorateBranch(@NotNull DecoratedNavObjectFactory decoratedNavObjectFactory, @NotNull ImmutableChainBranch branch, @NotNull DecoratedPlan master) {
        return new DecoratedBranch(decoratedNavObjectFactory, branch, master);
    }

    private DecoratedPlan(@NotNull ImmutablePlan plan) {
        this.planIdentifier = plan instanceof ChainBranchIdentifier ? new ChainBranchIdentifierImpl((ChainBranchIdentifier)plan) : new PlanIdentifierImpl((PlanIdentifier)plan);
        this.labelNames = ImmutableList.copyOf((Collection)plan.getLabelNames());
    }

    private DecoratedPlan(@NotNull PlanIdentifier planIdentifier) {
        this.planIdentifier = planIdentifier;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.planIdentifier.getPlanKey().getKey();
    }

    @NotNull
    public String getBuildKey() {
        return this.planIdentifier.getBuildKey();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.planIdentifier.getBuildName();
    }

    @Override
    @NotNull
    public ImmutableList<? extends DecoratedNavGroupObject> getNavGroups() {
        return this.getStages();
    }

    @Override
    @Nullable
    public abstract DecoratedPlan getParent();

    @Override
    @NotNull
    public PlanType getPlanType() {
        return this.planIdentifier.getPlanType();
    }

    @Override
    @Nullable
    public DecoratedNavObjectStatus getStatus() {
        return null;
    }

    @Override
    @Nullable
    public String replaceKey(String url, DecoratedNavObject originalObject) {
        DecoratedPlan originalPlan = (DecoratedPlan)Narrow.to((Object)originalObject, DecoratedPlan.class);
        if (originalPlan != null) {
            if (url.contains(originalPlan.getKey())) {
                return url.replaceAll(originalPlan.getKey(), this.getKey());
            }
            return url.replaceAll("\\$\\{planKey\\}", this.getKey());
        }
        return null;
    }

    @Override
    @Nullable
    public abstract DecoratedPlan getMaster();

    public long getId() {
        return this.planIdentifier.getId();
    }

    @NotNull
    public Optional<Long> getDatabaseId() {
        return this.planIdentifier.getDatabaseId();
    }

    @NotNull
    public PlanKey getPlanKey() {
        return this.planIdentifier.getPlanKey();
    }

    @NotNull
    public String getName() {
        return this.planIdentifier.getName();
    }

    @NotNull
    public ProjectIdentifier getProject() {
        return this.planIdentifier.getProject();
    }

    @NotNull
    public String getBuildName() {
        return this.planIdentifier.getBuildName();
    }

    public String getDescription() {
        return this.planIdentifier.getDescription();
    }

    public long getMasterId() {
        return this.planIdentifier.getMasterId();
    }

    @NotNull
    public Optional<Long> getMasterIdIfExists() {
        return this.planIdentifier.getMasterIdIfExists();
    }

    public ImmutableList<String> getLabelNames() {
        return this.labelNames;
    }

    @Override
    @NotNull
    public String getType() {
        return this.planIdentifier.getPlanType().name();
    }

    @Override
    public boolean isResult() {
        return false;
    }

    public boolean isSuspendedFromBuilding() {
        return this.planIdentifier.isSuspendedFromBuilding();
    }

    public ImmutableList<DecoratedStage> getStages() {
        return ImmutableList.of();
    }

    public ImmutableList<DecoratedPlanBranchGist> getBranches() {
        return ImmutableList.of();
    }

    public void setLabels(ImmutableList<String> labels) {
        this.labelNames = labels;
    }

    @Nullable
    public abstract String getBranchName();

    @Nullable
    public abstract PlanBranchWorkflow getPlanBranchWorkflow();

    @Nullable
    public String getLinkedJiraIssue() {
        ChainBranchIdentifier branchIdentifier = (ChainBranchIdentifier)Narrow.to((Object)this.planIdentifier, ChainBranchIdentifier.class);
        return branchIdentifier != null ? branchIdentifier.getLinkedJiraIssue() : null;
    }

    public boolean isRemoteJiraLinkRequired() {
        ChainBranchIdentifier branchIdentifier = (ChainBranchIdentifier)Narrow.to((Object)this.planIdentifier, ChainBranchIdentifier.class);
        return branchIdentifier != null && branchIdentifier.isRemoteJiraLinkRequired();
    }

    @NotNull
    public String getMasterChainKey() {
        PlanIdentifier masterPlanIdentifier = this.getMasterPlanIdentifier();
        String planKey = masterPlanIdentifier.getPlanType().equals((Object)PlanType.JOB) ? PlanKeys.getChainKeyFromJobKey((PlanKey)masterPlanIdentifier.getPlanKey()).getKey() : masterPlanIdentifier.getPlanKey().getKey();
        return planKey;
    }

    @Nullable
    public String getMasterJobKey() {
        String jobKey = null;
        if (this.planIdentifier.getPlanType().equals((Object)PlanType.JOB)) {
            jobKey = this.planIdentifier.getPlanKey().getKey();
        }
        return jobKey;
    }

    @Nullable
    public String getBranchPlanKey() {
        String branchPlanKey = null;
        if (this.planIdentifier.getPlanType().equals((Object)PlanType.CHAIN_BRANCH)) {
            branchPlanKey = this.planIdentifier.getPlanKey().getKey();
        }
        return branchPlanKey;
    }

    private PlanIdentifier getMasterPlanIdentifier() {
        return this.getMaster() != null ? this.getMaster() : this.planIdentifier;
    }

    public abstract List<DeploymentProject> getRelatedDeploymentProjects();

    @Nullable
    public abstract DecoratedStage getStageWithName(@NotNull String var1);

    public static class DecoratedPlanBranchGist {
        private final DecoratedPlan master;
        private final PlanKey key;
        private final String buildName;
        private final boolean suspendedFromBuilding;
        private final PlanBranchWorkflow planBranchWorkflow;

        public DecoratedPlanBranchGist(DecoratedPlan master, PlanBranchGist gist) {
            this.master = master;
            this.key = gist.getKey();
            this.buildName = gist.getBuildName();
            this.suspendedFromBuilding = gist.isSuspendedFromBuilding();
            this.planBranchWorkflow = gist.getPlanBranchWorkflow();
        }

        public DecoratedPlan getMaster() {
            return this.master;
        }

        public PlanKey getKey() {
            return this.key;
        }

        public String getDisplayName() {
            return this.buildName;
        }

        public boolean isSuspendedFromBuilding() {
            return this.suspendedFromBuilding;
        }

        public PlanBranchWorkflow getPlanBranchWorkflow() {
            return this.planBranchWorkflow;
        }
    }

    public static class DecoratedBranch
    extends DecoratedPlan {
        private final DecoratedPlan master;
        private final String branchName;
        private final PlanBranchWorkflow planBranchWorkflow;
        private final boolean divergent;
        private final boolean awaitingSpecsExecution;
        private final ImmutableList<DecoratedStage> stages;

        public DecoratedBranch(@NotNull DecoratedNavObjectFactory decoratedNavObjectFactory, @NotNull ImmutableChainBranch branch, @NotNull DecoratedPlan master) {
            super((ImmutablePlan)branch);
            this.divergent = branch.isDivergent();
            this.stages = this.divergent ? ImmutableList.copyOf((Collection)branch.getStages().stream().map(arg_0 -> decoratedNavObjectFactory.getStageDecorator(this).apply(arg_0)).collect(Collectors.toList())) : null;
            this.master = master;
            this.branchName = branch.getBuildName();
            this.planBranchWorkflow = branch.getBuildDefinition().getBranchSpecificConfiguration().getPlanBranchWorkflow();
            this.awaitingSpecsExecution = branch.getBuildDefinition().getBranchSpecificConfiguration().isAwaitingSpecsExecution();
        }

        @Override
        @NotNull
        public DecoratedPlan getMaster() {
            return this.master;
        }

        @Override
        public List<DeploymentProject> getRelatedDeploymentProjects() {
            return this.master.getRelatedDeploymentProjects();
        }

        @Override
        @Nullable
        public DecoratedPlan getParent() {
            return null;
        }

        @Override
        @Nullable
        public String getBranchName() {
            return this.branchName;
        }

        public boolean isDivergent() {
            return this.divergent;
        }

        public boolean isAwaitingSpecsExecution() {
            return this.awaitingSpecsExecution;
        }

        @Override
        @Nullable
        public PlanBranchWorkflow getPlanBranchWorkflow() {
            return this.planBranchWorkflow;
        }

        @Override
        @Nullable
        public DecoratedStage getStageWithName(@NotNull String stageName) {
            if (this.divergent) {
                for (DecoratedStage stage : this.stages) {
                    if (!stage.getName().equals(stageName)) continue;
                    return stage;
                }
                return null;
            }
            return this.master.getStageWithName(stageName);
        }

        @Override
        public ImmutableList<DecoratedStage> getStages() {
            if (this.divergent) {
                return this.stages;
            }
            return this.getMaster().getStages();
        }
    }

    private static class DecoratedJob
    extends DecoratedPlan {
        private final DecoratedPlan parent;

        public DecoratedJob(@NotNull DecoratedPlan parent, @NotNull ImmutablePlan plan) {
            super(plan);
            this.parent = parent;
        }

        public DecoratedJob(final DecoratedPlan parent, final BuildResultsSummary resultsSummary) {
            super(new PlanIdentifier(){

                public long getId() {
                    return 0L;
                }

                @NotNull
                public Optional<Long> getDatabaseId() {
                    return Optional.of(0L);
                }

                @NotNull
                public Optional<Long> getMasterIdIfExists() {
                    return Optional.empty();
                }

                @NotNull
                public PlanType getPlanType() {
                    return PlanType.JOB;
                }

                @NotNull
                public PlanKey getPlanKey() {
                    return resultsSummary.getPlanKey();
                }

                @NotNull
                public String getBuildKey() {
                    return resultsSummary.getBuildKey();
                }

                @NotNull
                public String getName() {
                    return resultsSummary.getFullPlanName();
                }

                @NotNull
                public String getBuildName() {
                    return resultsSummary.getPlanName();
                }

                public boolean isSuspendedFromBuilding() {
                    return false;
                }

                @NotNull
                public ProjectIdentifier getProject() {
                    return parent.getProject();
                }

                public long getMasterId() {
                    return -1L;
                }

                @Nullable
                public String getDescription() {
                    return null;
                }
            });
            this.parent = parent;
        }

        @Override
        @Nullable
        public DecoratedPlan getMaster() {
            return this.parent.getMaster();
        }

        @Override
        public List<DeploymentProject> getRelatedDeploymentProjects() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public DecoratedPlan getParent() {
            return this.parent;
        }

        @Override
        @Nullable
        public String getBranchName() {
            return null;
        }

        @Override
        @Nullable
        public PlanBranchWorkflow getPlanBranchWorkflow() {
            return null;
        }

        @Override
        @Nullable
        public DecoratedStage getStageWithName(@NotNull String stageName) {
            return null;
        }
    }

    private static class DecoratedChain
    extends DecoratedPlan {
        private final ImmutableList<DeploymentProject> deploymentProjects;
        private final ImmutableList<DecoratedStage> stages;
        private final Supplier<ImmutableList<DecoratedPlanBranchGist>> branches;
        private final String branchName;
        private final PlanBranchWorkflow planBranchWorkflow;

        public DecoratedChain(@NotNull DecoratedNavObjectFactory decoratedNavObjectFactory, @NotNull ImmutableChain chain, @NotNull List<DeploymentProject> deploymentProjects) {
            super((ImmutablePlan)chain);
            this.deploymentProjects = ImmutableList.copyOf(deploymentProjects);
            this.stages = ImmutableList.copyOf((Collection)chain.getStages().stream().map(arg_0 -> decoratedNavObjectFactory.getStageDecorator(this).apply(arg_0)).collect(Collectors.toList()));
            this.branches = Lazy.supplier(() -> decoratedNavObjectFactory.getDecoratedChainBranchIdentifiers(this));
            this.branchName = decoratedNavObjectFactory.getSubstitutedBranchName(chain);
            this.planBranchWorkflow = chain.getBuildDefinition().getBranchMonitoringConfiguration().getPlanBranchWorkflow();
        }

        @Override
        @Nullable
        public DecoratedPlan getMaster() {
            return null;
        }

        @Override
        public List<DeploymentProject> getRelatedDeploymentProjects() {
            return this.deploymentProjects;
        }

        @Override
        @Nullable
        public DecoratedPlan getParent() {
            return null;
        }

        @Override
        @Nullable
        public DecoratedStage getStageWithName(@NotNull String stageName) {
            for (DecoratedStage stage : this.stages) {
                if (!stage.getName().equals(stageName)) continue;
                return stage;
            }
            return null;
        }

        @Override
        public ImmutableList<DecoratedStage> getStages() {
            return this.stages;
        }

        @Override
        public ImmutableList<DecoratedPlanBranchGist> getBranches() {
            try {
                return this.branches.get();
            }
            catch (LazyReference.InitializationException e) {
                throw Throwables.propagate((Throwable)e.getCause());
            }
        }

        @Override
        @Nullable
        public String getBranchName() {
            return this.branchName;
        }

        @Override
        @Nullable
        public PlanBranchWorkflow getPlanBranchWorkflow() {
            return this.planBranchWorkflow;
        }
    }
}

