/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.beans;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.ChainBranchUtils;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.PlanBranchGist;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.ww2.beans.DecoratedNavObjectFactory;
import com.atlassian.bamboo.ww2.beans.DecoratedPlan;
import com.atlassian.bamboo.ww2.beans.DecoratedResult;
import com.atlassian.bamboo.ww2.beans.DecoratedStage;
import com.atlassian.bamboo.ww2.beans.DecoratedStageResult;
import com.atlassian.collectors.CollectorsUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.opensymphony.xwork2.TextProvider;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecoratedNavObjectFactoryImpl
implements DecoratedNavObjectFactory {
    private final TextProvider textProvider;
    private final CustomVariableContext customVariableContext;
    private final CachedPlanManager cachedPlanManager;
    private final DeploymentProjectService deploymentProjectService;

    public DecoratedNavObjectFactoryImpl(CachedPlanManager cachedPlanManager, TextProvider textProvider, CustomVariableContext customVariableContext, DeploymentProjectService deploymentProjectService) {
        this.textProvider = textProvider;
        this.customVariableContext = customVariableContext;
        this.cachedPlanManager = cachedPlanManager;
        this.deploymentProjectService = deploymentProjectService;
    }

    @Override
    @Nullable
    public DecoratedPlan decoratePlan(@NotNull ImmutablePlan possiblyMutablePlan) {
        ImmutablePlan immutablePlan = this.cachedPlanManager.getPlanByKey(possiblyMutablePlan.getPlanKey());
        ImmutableJob immutableJob = (ImmutableJob)Narrow.downTo((Object)immutablePlan, ImmutableJob.class);
        if (immutableJob != null) {
            return this.decorateChainAndFindJob(immutableJob);
        }
        ImmutableChainBranch immutableBranch = (ImmutableChainBranch)Narrow.downTo((Object)immutablePlan, ImmutableChainBranch.class);
        if (immutableBranch != null) {
            return this.decorateMasterAndFindBranch(immutableBranch);
        }
        ImmutableChain immutableChain = (ImmutableChain)Narrow.downTo((Object)immutablePlan, ImmutableChain.class);
        if (immutableChain != null) {
            return this.decorateChain(immutableChain);
        }
        return null;
    }

    @NotNull
    private DecoratedPlan decorateChain(ImmutableChain immutableChain) {
        PlanKey planKey = immutableChain.getPlanKey();
        List deploymentProjects = this.deploymentProjectService.getDeploymentProjectsRelatedToPlan(planKey);
        return DecoratedPlan.decorateChain(this, immutableChain, deploymentProjects);
    }

    @NotNull
    private DecoratedPlan decorateMasterAndFindBranch(ImmutableChainBranch branch) {
        ImmutableChain master = (ImmutableChain)Preconditions.checkNotNull((Object)branch.getMaster(), (Object)("Branch " + branch.getPlanKey() + " (" + branch.getClass() + ") has no master"));
        DecoratedPlan decoratedParent = this.decorateChain(master);
        return new DecoratedPlan.DecoratedBranch(this, branch, decoratedParent);
    }

    private DecoratedPlan decorateChainAndFindJob(ImmutableJob immutableJob) {
        ImmutableChain immutableParent = immutableJob.getParent();
        if (immutableParent != null) {
            if (immutableParent.hasMaster()) {
                DecoratedPlan decoratedParent = this.decorateMasterAndFindBranch((ImmutableChainBranch)immutableParent);
                return DecoratedPlan.decorateJob(decoratedParent, (ImmutablePlan)immutableJob);
            }
            DecoratedPlan decoratedParent = this.decorateChain(immutableParent);
            DecoratedStage stageWithName = decoratedParent.getStageWithName(immutableJob.getStage().getName());
            if (stageWithName == null) {
                return null;
            }
            return stageWithName.getJobWithKey(immutableJob.getPlanKey());
        }
        return null;
    }

    @Override
    public Function<ImmutableChainStage, DecoratedStage> getStageDecorator(@NotNull DecoratedPlan parent) {
        return chainStage -> {
            ImmutableChainStage stage = (ImmutableChainStage)Preconditions.checkNotNull((Object)chainStage);
            return new DecoratedStage(this.textProvider, stage, (Iterable<DecoratedPlan>)stage.getJobs().stream().map(arg_0 -> this.getJobDecorator(parent).apply(arg_0)).collect(Collectors.toList()));
        };
    }

    @Override
    public Function<ChainStageResult, DecoratedStage> getStageResultDecorator(@NotNull DecoratedPlan parent) {
        return chainStageResult -> {
            Set buildResults = chainStageResult.getBuildResults();
            return new DecoratedStage(this.textProvider, (ChainStageResult)chainStageResult, (Iterable<DecoratedPlan>)buildResults.stream().map(arg_0 -> this.getJobResultDecorator(parent).apply(arg_0)).collect(Collectors.toList()));
        };
    }

    @Override
    public ImmutableList<DecoratedPlan> getDecoratedChainBranches(@NotNull DecoratedPlan master) {
        return (ImmutableList)this.cachedPlanManager.getBranchesOfChain(master.getPlanKey()).map(branch -> DecoratedPlan.decorateBranch(this, branch, master)).collect(CollectorsUtil.toImmutableList());
    }

    @Override
    public ImmutableList<DecoratedPlan.DecoratedPlanBranchGist> getDecoratedChainBranchIdentifiers(@NotNull DecoratedPlan master) {
        return (ImmutableList)this.cachedPlanManager.getBranchGistsOfChain(master.getPlanKey()).stream().sorted(PlanBranchGist.PlanNameCaseInsensitiveComparator.ORDERING).map(bGist -> new DecoratedPlan.DecoratedPlanBranchGist(master, (PlanBranchGist)bGist)).collect(CollectorsUtil.toImmutableList());
    }

    @Override
    public DecoratedPlan getDecoratedPlan(ChainResultsSummary resultSummary) {
        ImmutableChain immutablePlanByKey = (ImmutableChain)this.cachedPlanManager.getPlanByKeyIfOfType(resultSummary.getPlanKey(), ImmutableChain.class);
        if (immutablePlanByKey != null) {
            return this.decoratePlan((ImmutablePlan)immutablePlanByKey);
        }
        return this.decoratePlan((ImmutablePlan)resultSummary.getImmutablePlan());
    }

    @Override
    @Nullable
    public String getSubstitutedBranchName(@NotNull ImmutableChain chain) {
        return ChainBranchUtils.getChainBranchName((CustomVariableContext)this.customVariableContext, (ImmutablePlan)chain);
    }

    @Override
    @NotNull
    public DecoratedResult decorateResult(ResultsSummary summary) {
        BuildResultsSummary jobResult = (BuildResultsSummary)Narrow.to((Object)summary, BuildResultsSummary.class);
        if (jobResult != null) {
            return this.getDecoratedResultHierarchyAndRetrieveJobResult(jobResult);
        }
        return this.decorateChainResult((ChainResultsSummary)summary);
    }

    private DecoratedResult decorateChainResult(ChainResultsSummary chainResultsSummary) {
        DecoratedPlan decoratedPlan = this.getDecoratedPlan(chainResultsSummary);
        return DecoratedResult.decorateChainResult(chainResultsSummary, decoratedPlan, this);
    }

    private DecoratedResult getDecoratedResultHierarchyAndRetrieveJobResult(BuildResultsSummary jobResult) {
        ChainResultsSummary parentResult = jobResult.getChainResultsSummary();
        if (parentResult == null) {
            throw new IllegalStateException("Top Level Result not found for: " + jobResult);
        }
        DecoratedResult decoratedParent = this.decorateChainResult(parentResult);
        for (DecoratedStageResult stage : decoratedParent.getStageResults()) {
            for (DecoratedResult decJob : stage.getBuildResults()) {
                if (!decJob.getPlanResultKey().equals((Object)jobResult.getPlanResultKey())) continue;
                return decJob;
            }
        }
        return null;
    }

    private Function<ImmutableJob, DecoratedPlan> getJobDecorator(@NotNull DecoratedPlan parent) {
        return job -> DecoratedPlan.decorateJob(parent, (ImmutablePlan)Preconditions.checkNotNull((Object)job));
    }

    private Function<BuildResultsSummary, DecoratedPlan> getJobResultDecorator(@NotNull DecoratedPlan parent) {
        return resultsSummary -> DecoratedPlan.decorateJobResult(parent, resultsSummary);
    }
}

