/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.user;

import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.author.ExtendedAuthorManager;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.AuthenticatedUserSecurityAware;
import com.atlassian.user.User;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ViewUserSummary
extends BambooActionSupport
implements AuthenticatedUserSecurityAware {
    private static final Logger log = Logger.getLogger(ViewUserSummary.class);
    BambooUser currentUser;
    private String currentUserName;
    private List<ExtendedAuthor> repositoryAliases;
    private ExtendedAuthorManager extendedAuthorManager;

    @Override
    public String doDefault() throws Exception {
        if (this.getCurrentUser() != null) {
            return "input";
        }
        this.addActionError(this.getText("user.admin.edit.failed", new String[]{this.currentUserName}));
        return "error";
    }

    @Nullable
    public BambooUser getCurrentUser() {
        if (this.currentUser == null) {
            if (StringUtils.isBlank((CharSequence)this.currentUserName)) {
                User user = this.getUser();
                if (user != null) {
                    this.currentUser = this.getBambooUserManager().getBambooUser(user.getName());
                }
            } else {
                this.currentUser = this.getBambooUserManager().getBambooUser(this.currentUserName);
            }
        }
        return this.currentUser;
    }

    public List<ExtendedAuthor> getRepositoryAliases() {
        if (this.repositoryAliases == null) {
            this.repositoryAliases = this.extendedAuthorManager.getLinkedAuthorForUser(this.getCurrentUser().getUser());
        }
        return this.repositoryAliases;
    }

    public List getTopNByDateDesc(List list, int size) {
        this.sortDescDate(list);
        return list.subList(0, Math.min(size, list.size()));
    }

    private void sortDescDate(List<ResultsSummary> breakages) {
        Collections.sort(breakages, Collections.reverseOrder(Comparators.getBuildCompletedDateComparator()));
    }

    public String getCurrentUserName() {
        return this.currentUserName;
    }

    public void setCurrentUserName(String currentUserName) {
        this.currentUserName = currentUserName;
    }

    public void setExtendedAuthorManager(ExtendedAuthorManager extendedAuthorManager) {
        this.extendedAuthorManager = extendedAuthorManager;
    }
}

