/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.setup;

import com.atlassian.bamboo.agent.AgentSecurityTokenService;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationPersister;
import com.atlassian.bamboo.configuration.InetAddressBean;
import com.atlassian.bamboo.configuration.RssSecurityConfiguration;
import com.atlassian.bamboo.configuration.StorageLimits;
import com.atlassian.bamboo.persister.file.FileBasedPersister;
import com.atlassian.bamboo.persister.xstream.CustomizableXStreamFactory;
import com.atlassian.bamboo.persister.xstream.XStreamFactory;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.webwork.StrutsSupport;
import com.atlassian.bamboo.ww2.actions.setup.BambooSetupConstants;
import com.atlassian.config.ConfigurationException;
import com.atlassian.config.db.DatabaseDetails;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.crowd.embedded.EmbeddedCrowdBootstrap;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.google.common.base.Supplier;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetupUtilityBean {
    private static final Logger log = Logger.getLogger(SetupUtilityBean.class);
    protected static final String BAMBOO_HOME_EXPRESSION = "${bambooHome}" + File.separator;
    public static final String EMBEDDED_DATABASE_TYPE = "h2";
    private Supplier<EmbeddedCrowdBootstrap> embeddedCrowdBootstrap = ComponentAccessor.newLazyComponentReference((String)"embeddedCrowdBootstrap");

    private void setBrokerClientURI(URI uri) {
        BootstrapManager bootstrapManager = this.getBootstrapManager();
        bootstrapManager.setBrokerClientURI(uri);
    }

    public synchronized void setupGeneralConfiguration(@Nullable String instanceName, String baseUrl, String configDir, String buildWorkingDir, String buildDir, String artifactsDir, @Nullable String brokerURI, String repositoryLogsDir, ErrorCollection errorCollection) throws URISyntaxException, ConfigurationException {
        log.info((Object)"Creating the directory structure...");
        BootstrapManager bootstrapManager = this.getBootstrapManager();
        bootstrapManager.setConfigDirectory(configDir);
        bootstrapManager.setBuildWorkingDirectory(buildWorkingDir);
        bootstrapManager.setBuildDirectory(buildDir);
        bootstrapManager.setArtifactsDirectory(artifactsDir);
        bootstrapManager.setRepositoryLogsDirectory(repositoryLogsDir);
        bootstrapManager.getBrokerClientURI();
        if (!StringUtils.isBlank((CharSequence)brokerURI)) {
            bootstrapManager.setBrokerURI(new URI(brokerURI));
        } else {
            bootstrapManager.getBrokerURI();
        }
        this.setupDirectory(BAMBOO_HOME_EXPRESSION + "index", "Bamboo failed to create the index directory for Lucene", errorCollection);
        bootstrapManager.setProperty("lucene.index.dir", (Object)(BAMBOO_HOME_EXPRESSION + "index"));
        this.setupDirectory(BAMBOO_HOME_EXPRESSION + "temp", "Bamboo failed to create the temp directory", errorCollection);
        bootstrapManager.setProperty("webwork.multipart.saveDir", (Object)(BAMBOO_HOME_EXPRESSION + "temp"));
        this.setupDirectory(BAMBOO_HOME_EXPRESSION + "backups", "Bamboo failed to create the backup directory", errorCollection);
        if (!errorCollection.hasAnyErrors()) {
            bootstrapManager.save();
            FileBasedPersister persister = new FileBasedPersister(bootstrapManager, (XStreamFactory)new CustomizableXStreamFactory());
            AdministrationConfiguration adminConfig = persister.getAdministrationConfiguration();
            adminConfig.setBaseUrl(baseUrl);
            if (instanceName != null) {
                adminConfig.setInstanceName(instanceName);
            }
            adminConfig.setXsrfProtectionEnabled(true);
            adminConfig.setXsrfAllowsMutativeGets(false);
            this.setupStorageLimits(adminConfig);
            adminConfig.setRemoteAgentFunctionEnabled(true);
            adminConfig.setRemoteAgentAuthenticationEnabled(true);
            persister.saveAdministrationConfiguration(adminConfig);
        }
    }

    private void setupStorageLimits(AdministrationConfiguration adminConfig) {
        StorageLimits storageLimits = new StorageLimits(20, 25);
        adminConfig.setStorageLimit(storageLimits);
    }

    public void setupDefaultGeneralConfiguration(String requestUrl, String servletPath, ErrorCollection errorCollection) throws URISyntaxException, ConfigurationException {
        log.info((Object)"Setting up default general configuration...");
        BootstrapManager bootstrapManager = this.getBootstrapManager();
        String home = bootstrapManager.getApplicationHome() + File.separator;
        this.setupGeneralConfiguration("Atlassian Bamboo", this.getDefaultBaseUrl(requestUrl, servletPath), home + BambooSetupConstants.DEFAULT_CONFIG_DIRECTORY, home + BambooSetupConstants.DEFAULT_BUILD_WORKING_DIRECTORY, home + BambooSetupConstants.DEFAULT_BUILD_DIRECTORY, home + "artifacts", null, home + BambooSetupConstants.DEFAULT_REPOSITORY_SPECS_DIRECTORY, errorCollection);
        log.info((Object)"Directory structure created.");
    }

    public String getDefaultBaseUrl(String requestUrl, String servletPath) {
        if (StringUtils.isEmpty((CharSequence)requestUrl) || requestUrl.length() <= servletPath.length()) {
            return "http://localhost:8085";
        }
        String localhostUrl = requestUrl.substring(0, requestUrl.length() - servletPath.length());
        return InetAddressBean.getLocalHostAddressForUrl().map(address -> StringUtils.replace((String)localhostUrl, (String)"localhost", (String)address)).orElse(localhostUrl);
    }

    public synchronized void setupAgentsSecurityToken(@NotNull ErrorCollection errorCollection, boolean featureEnabled) {
        AgentSecurityTokenService agentSecurityTokenService = (AgentSecurityTokenService)ComponentAccessor.AGENT_SECURITY_TOKEN_SERVICE.get();
        if (agentSecurityTokenService != null) {
            agentSecurityTokenService.resetSecurityToken();
        } else {
            errorCollection.addErrorMessage("Security token service could not be found");
        }
        AdministrationConfiguration administrationConfiguration = (AdministrationConfiguration)ComponentAccessor.PROTOTYPE_ADMINISTRATION_CONFIGURATION.get();
        AdministrationConfigurationPersister configurationPersister = (AdministrationConfigurationPersister)ComponentAccessor.ADMINISTRATION_CONFIGURATION_PERSISTER.get();
        if (administrationConfiguration != null && configurationPersister != null) {
            administrationConfiguration.setSecurityTokenRequiredFromAgents(featureEnabled);
            configurationPersister.saveAdministrationConfiguration(administrationConfiguration);
        } else {
            if (administrationConfiguration == null) {
                errorCollection.addErrorMessage("Could not access administration configuration");
            }
            if (configurationPersister == null) {
                errorCollection.addErrorMessage("Administration configuration persister could not be found");
            }
        }
    }

    public void setupEmbeddedDatabase(ServletContext servletContext, ErrorCollection errorCollection) throws ConfigurationException {
        String database = EMBEDDED_DATABASE_TYPE;
        DatabaseDetails dbconfig = DatabaseDetails.getDefaults((String)database);
        if (!this.isDriverValid(dbconfig)) {
            errorCollection.addErrorMessage("Bamboo could not find the database driver for the embedded database");
        } else {
            this.setupStandardDatabase(database, dbconfig, servletContext, errorCollection);
        }
    }

    public void setupStandardDatabase(String selectedDatabase, DatabaseDetails dbDetails, ServletContext servletContext, ErrorCollection errorCollection) {
        try {
            log.info((Object)("Setting up database: " + selectedDatabase));
            dbDetails.setupForDatabase(selectedDatabase);
            log.info((Object)("Bootstrapping database: " + selectedDatabase));
            this.getBootstrapManager().bootstrapDatabase(dbDetails, false);
            log.info((Object)"Database set up.");
            this.refreshStruts(servletContext);
        }
        catch (Exception e) {
            errorCollection.addErrorMessage("Database configuration failed: ");
            errorCollection.addErrorMessage(e.getMessage());
            log.error((Object)("Database configuration failed. " + e.getMessage()), (Throwable)e);
        }
    }

    public void setupDatasourceDatabase(String selectedDatasource, DatabaseDetails dbDetails, String datasourceName, ServletContext servletContext, ErrorCollection errorCollection) {
        try {
            log.info((Object)("Setting up datasource: " + selectedDatasource));
            dbDetails.setupForDatabase(selectedDatasource);
            this.getBootstrapManager().bootstrapDatasource(datasourceName, dbDetails.getDialect());
            this.refreshStruts(servletContext);
        }
        catch (Exception e) {
            errorCollection.addErrorMessage("Database configuration failed: ");
            errorCollection.addErrorMessage(e.getMessage());
            log.error((Object)("Unable to bootstrap datasource: " + e.getMessage()), (Throwable)e);
        }
    }

    public void setupUser(String username, String password, String email, String fullName, ErrorCollection errorCollection) {
        try {
            ((EmbeddedCrowdBootstrap)this.embeddedCrowdBootstrap.get()).initialiseEmbeddedCrowd();
        }
        catch (ApplicationNotFoundException | DirectoryNotFoundException e) {
            errorCollection.addErrorMessage("An error has occurred during user management initialisation", (Exception)e);
        }
        BambooUserManager bambooUserManager = (BambooUserManager)ComponentAccessor.BAMBOO_USER_MANAGER.get();
        if (bambooUserManager != null) {
            bambooUserManager.setupInitialAdminUser(username, password, email, fullName);
        } else {
            errorCollection.addErrorMessage("Could not complete Bamboo installation (setting up admin user and default group), Bamboo user manager could not be found.");
        }
        AdministrationConfiguration administrationConfiguration = (AdministrationConfiguration)ComponentAccessor.PROTOTYPE_ADMINISTRATION_CONFIGURATION.get();
        AdministrationConfigurationPersister configurationPersister = (AdministrationConfigurationPersister)ComponentAccessor.ADMINISTRATION_CONFIGURATION_PERSISTER.get();
        if (administrationConfiguration == null) {
            errorCollection.addErrorMessage("Could not complete Bamboo installation - component 'administration configuration' was not available");
        } else if (configurationPersister == null) {
            errorCollection.addErrorMessage("Could not complete Bamboo installation - component 'administration configuration persister' was not available");
        } else {
            this.setupDeploymentExpirySetting(administrationConfiguration);
            this.setupRssSecuritySettings(administrationConfiguration);
            configurationPersister.saveAdministrationConfiguration(administrationConfiguration);
        }
    }

    private void setupDeploymentExpirySetting(@NotNull AdministrationConfiguration administrationConfiguration) {
        administrationConfiguration.setDeploymentExpiryEnabled(true);
    }

    private void setupRssSecuritySettings(@NotNull AdministrationConfiguration administrationConfiguration) {
        RssSecurityConfiguration rssSecurity = administrationConfiguration.getRssSecurityConfiguration();
        administrationConfiguration.setRssSecurityConfiguration(new RssSecurityConfiguration(rssSecurity.isEnabled(), SystemProperty.SETUP_RSS_IN_DOCKER.getTypedValue(), rssSecurity.getDockerImage()));
    }

    private void refreshStruts(ServletContext servletContext) {
        log.info((Object)"Refreshing Struts configuration...");
        StrutsSupport.getDispatchers().reload();
        servletContext.removeAttribute("freemarker.Configuration");
    }

    @Nullable
    private File setupDirectory(String dirName, String failureMessage, ErrorCollection errorCollection) {
        File dir;
        if (dirName == null || dirName.trim().equals("")) {
            errorCollection.addErrorMessage(failureMessage + ": Provided directory name was empty");
            return null;
        }
        if (StringUtils.contains((CharSequence)dirName, (CharSequence)"${bambooHome}")) {
            dirName = StringUtils.replace((String)dirName, (String)"${bambooHome}", (String)this.getBootstrapManager().getApplicationHome());
        }
        if (!(dir = new File(dirName)).isDirectory() && !dir.mkdirs()) {
            errorCollection.addErrorMessage(failureMessage + ": " + dir.getAbsolutePath());
            return null;
        }
        return dir;
    }

    private boolean isDriverValid(DatabaseDetails dbDetails) {
        try {
            Class.forName(dbDetails.getDriverClassName());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public BootstrapManager getBootstrapManager() {
        return (BootstrapManager)BootstrapUtils.getBootstrapManager();
    }
}

