/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.setup;

import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.security.LogoutSupport;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.ww2.actions.setup.AbstractSetupAction;
import com.atlassian.bamboo.ww2.actions.setup.LessAttendedSetup;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.license.DefaultSIDManager;
import com.atlassian.license.SIDManager;
import org.apache.commons.lang3.StringUtils;

public class SetupLicenseAction
extends AbstractSetupAction {
    private static final String SETUP_EXPRESS = "express-setup";
    private String licenseString;
    private String sid;
    private String expressInstall;
    private BambooLicenseManager bambooLicenseManager;

    public String input() throws Exception {
        String license;
        LogoutSupport.logout(RequestCacheThreadLocal.getNonNullRequest(), RequestCacheThreadLocal.getNonNullResponse());
        String bambooSid = this.getBootstrapManager().getServerID();
        boolean modifiedConfig = false;
        if (bambooSid == null || !this.getSidManager().isValidSID(bambooSid)) {
            bambooSid = this.getSidManager().generateSID();
            this.getBootstrapManager().setServerID(bambooSid);
            modifiedConfig = true;
        }
        this.sid = bambooSid;
        modifiedConfig = this.getBootstrapManager().initializeServerKey() || modifiedConfig;
        boolean bl = modifiedConfig = this.getBootstrapManager().resetH2Version() || modifiedConfig;
        if (modifiedConfig) {
            this.getBootstrapManager().save();
        }
        if ((license = LessAttendedSetup.getLicense()) != null) {
            this.setLicenseString(license);
            return "unattended";
        }
        return "input";
    }

    public boolean isExpressSetupEnabled() {
        String setupType = LessAttendedSetup.getSetupType();
        return setupType == null || setupType.equals("express");
    }

    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.licenseString)) {
            this.addFieldError("licenseString", this.getText("license.error.required"));
        } else if (!this.getBambooLicenseManager().authenticateLicense(this.licenseString)) {
            this.addFieldError("licenseString", this.getText("license.error.invalid"));
        }
    }

    public String execute() throws Exception {
        if (this.isExpressInstall()) {
            this.getSetupPersister().setSetupType("install");
            this.getSetupPersister().progessSetupStep();
            this.getBambooLicenseManager().setLicense(this.licenseString);
            return SETUP_EXPRESS;
        }
        this.getSetupPersister().setSetupType("custom");
        this.getSetupPersister().progessSetupStep();
        this.getBambooLicenseManager().setLicense(this.licenseString);
        return "custom-setup";
    }

    public String getLicenseString() {
        return this.licenseString;
    }

    public void setLicenseString(String licenseString) {
        this.licenseString = licenseString;
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getVersion() {
        return BuildUtils.getCurrentVersion();
    }

    @Override
    public void setBambooLicenseManager(BambooLicenseManager bambooLicenseManager) {
        this.bambooLicenseManager = bambooLicenseManager;
    }

    @Override
    public BambooLicenseManager getBambooLicenseManager() {
        if (this.bambooLicenseManager == null) {
            this.bambooLicenseManager = (BambooLicenseManager)BootstrapUtils.getBootstrapContext().getBean("bambooLicenseManager");
        }
        return this.bambooLicenseManager;
    }

    public String getExpressInstall() {
        return this.expressInstall;
    }

    public void setExpressInstall(String expressInstall) {
        this.expressInstall = expressInstall;
    }

    public void setCustomInstall(String value) {
    }

    private boolean isExpressInstall() {
        return this.getExpressInstall() != null && this.getExpressInstall().startsWith(this.getText("setup.install.express"));
    }

    public SIDManager getSidManager() {
        return new DefaultSIDManager();
    }
}

