/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.setup;

import com.atlassian.bamboo.configuration.ScheduleBackupConfiguration;
import com.atlassian.bamboo.migration.ImportExportManager;
import com.atlassian.bamboo.security.ImpersonationHelper;
import com.atlassian.bamboo.security.LogoutSupport;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.upgrade.UpgradeLauncher;
import com.atlassian.bamboo.utils.BambooRunnables;
import com.atlassian.bamboo.ww2.actions.setup.AbstractSetupAction;
import com.atlassian.bamboo.ww2.actions.setup.LessAttendedSetup;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

public class SetupImportDataAction
extends AbstractSetupAction {
    private static final Logger log = Logger.getLogger(SetupImportDataAction.class);
    private String importPath;
    private String dataOption = "clean";
    private boolean importSuccessful;
    @Autowired
    private ImportExportManager importExportManager;
    private static final String OPTION_IMPORT = "import";
    private static final String OPTION_CLEAN = "clean";

    public String input() throws Exception {
        Boolean shouldImportExistingData = LessAttendedSetup.shouldImportExistingData();
        if (shouldImportExistingData != null) {
            Preconditions.checkArgument((shouldImportExistingData == false ? 1 : 0) != 0);
            log.info((Object)"Following unattended path");
            return "unattended";
        }
        return super.input();
    }

    public String execute() {
        if (!OPTION_IMPORT.equals(this.dataOption)) {
            this.getSetupPersister().progessSetupStep();
            return "success";
        }
        try {
            HttpServletRequest httpServletRequest = ServletActionContext.getRequest();
            HttpServletResponse httpServletResponse = ServletActionContext.getResponse();
            LogoutSupport.logout(httpServletRequest, httpServletResponse);
            ImpersonationHelper.runWithSystemAuthority(this.performImport());
            return "setupSuccess";
        }
        catch (Exception e) {
            this.addActionError(this.getText("setup.data.import.error") + e.getMessage());
            log.error((Object)"Failed to import", (Throwable)e);
            this.importSuccessful = false;
            return "error";
        }
    }

    private BambooRunnables.Throwing1<Exception> performImport() {
        return () -> {
            this.importExportManager.bambooImport(this.importPath);
            this.setupDirectories();
            this.getSetupPersister().finishSetup();
            UpgradeLauncher.upgradeAndStartBamboo(ServletActionContext.getServletContext(), false);
            this.importExportManager.bambooOsgiDependentImport(this.importPath);
            this.importExportManager.resetGenerators();
            UpgradeLauncher.initialisePlansAfterImport(ServletActionContext.getServletContext());
            this.addActionError(this.getText("setup.data.import.complete"));
            this.importSuccessful = true;
        };
    }

    public void validate() {
        File exportFile;
        if (OPTION_IMPORT.equals(this.dataOption) && StringUtils.isBlank((CharSequence)this.importPath)) {
            this.addFieldError("importPath", "Please enter the location of the zip file to import");
        }
        if (OPTION_IMPORT.equals(this.dataOption) && !StringUtils.isBlank((CharSequence)this.importPath) && !(exportFile = new File(this.importPath)).exists()) {
            this.addFieldError("importPath", "The file specified does not exist");
        }
    }

    private void setupDirectories() {
        String specificBackupDir;
        String backupType;
        String home = this.getBootstrapManager().getApplicationHome() + System.getProperty("file.separator");
        ScheduleBackupConfiguration scheduleBackupConfiguration = this.getAdministrationConfiguration().getScheduleBackupConfiguration();
        if (scheduleBackupConfiguration == null || scheduleBackupConfiguration.getBackupPath(home).equals(home + "backups")) {
            backupType = "automatic.backups";
            specificBackupDir = "${bambooHome}";
        } else {
            backupType = "specify.backup.dir";
            specificBackupDir = scheduleBackupConfiguration.getBackupPath(home);
        }
        String bambooHomeVelocityExpression = "${bambooHome}" + System.getProperty("file.separator");
        this.setupAttachmentPaths();
        this.setupDirectory(bambooHomeVelocityExpression + "index", "luceneIndexDir", "creating.lucene.index.dir.failed");
        this.setupDirectory(bambooHomeVelocityExpression + "temp", "tempDir", "creating.temp.dir.failed");
        if ("automatic.backups".equals(backupType)) {
            this.setupDirectory(bambooHomeVelocityExpression + "backups", "backupType", "creating.daily.backup.dir.failed");
        } else if ("specify.backup.dir".equals(backupType)) {
            this.setupDirectory(specificBackupDir, "specificBackupDir", "creating.daily.backup.dir.failed");
        }
        try {
            this.getBootstrapManager().setProperty("lucene.index.dir", (Object)(bambooHomeVelocityExpression + "index"));
            this.getBootstrapManager().setProperty("webwork.multipart.saveDir", (Object)(bambooHomeVelocityExpression + "temp"));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.addActionError(this.getText("error.recording.default.paths.to.system"));
        }
    }

    private void setupAttachmentPaths() {
        String home = "${bambooHome}" + System.getProperty("file.separator");
        BootstrapManager bootstrapManager = this.getBootstrapManager();
        bootstrapManager.setProperty("attachments.dir", (Object)(home + "attachments"));
        this.setupDirectory(home + "attachments", "attachmentsDir", "creating.attachments.dir.failed");
    }

    private File setupDirectory(String dirName, String fieldName, String failureMessageKey) {
        File dir;
        if (dirName == null || dirName.trim().equals("")) {
            return null;
        }
        if (StringUtils.contains((CharSequence)dirName, (CharSequence)"${bambooHome}")) {
            dirName = StringUtils.replace((String)dirName, (String)"${bambooHome}", (String)this.getBootstrapManager().getApplicationHome());
        }
        if (!(dir = new File(dirName)).isDirectory() && !dir.mkdirs()) {
            this.addFieldError(fieldName, this.getText(failureMessageKey));
            return null;
        }
        return dir;
    }

    public Map<String, String> getImportOptions() {
        return ImmutableMap.of((Object)OPTION_IMPORT, (Object)"Import existing data", (Object)OPTION_CLEAN, (Object)"Create a new Bamboo home");
    }

    public void setDataOption(String dataOption) {
        this.dataOption = dataOption;
    }

    public String getDataOption() {
        return this.dataOption;
    }

    public String getImportPath() {
        return this.importPath;
    }

    public void setImportPath(String importPath) {
        this.importPath = importPath;
    }

    public boolean isImportSuccessful() {
        return this.importSuccessful;
    }

    public void setImportSuccessful(boolean importSuccessful) {
        this.importSuccessful = importSuccessful;
    }
}

