/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.setup;

import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.ww2.actions.setup.AbstractSetupAction;
import com.atlassian.bamboo.ww2.actions.setup.BambooSetupConstants;
import com.atlassian.bamboo.ww2.actions.setup.LessAttendedSetup;
import com.atlassian.config.util.BootstrapUtils;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.interceptor.ServletRequestAware;

public class SetupGeneralConfiguration
extends AbstractSetupAction
implements ServletRequestAware {
    private static final Logger log = Logger.getLogger(SetupGeneralConfiguration.class);
    public static final String BUILD_WORKING_DIR = "buildWorkingDir";
    private String instanceName;
    private String baseUrl;
    private String configDir;
    private String artifactsDir;
    private String buildWorkingDir;
    private String buildDir;
    private String brokerURI;
    private String repositoryLogsDir;
    private BambooLicenseManager bambooLicenseManager;
    private String requestUrl;
    private String servletPath;
    private boolean isLessAttended;

    public String input() throws Exception {
        String home = this.getBootstrapManager().getApplicationHome() + System.getProperty("file.separator");
        this.setConfigDir(home + BambooSetupConstants.DEFAULT_CONFIG_DIRECTORY);
        this.setBuildWorkingDir(home + BambooSetupConstants.DEFAULT_BUILD_WORKING_DIRECTORY);
        this.setArtifactsDir(home + "artifacts");
        this.setBuildDir(home + BambooSetupConstants.DEFAULT_BUILD_DIRECTORY);
        this.setRepositoryLogsDir(home + BambooSetupConstants.DEFAULT_REPOSITORY_SPECS_DIRECTORY);
        this.setBrokerUrl(this.getBootstrapManager().getBrokerURI().toString());
        this.setInstanceName("Atlassian Bamboo");
        String unattendedBaseUrl = LessAttendedSetup.getBaseUrl();
        boolean bl = this.isLessAttended = unattendedBaseUrl != null;
        if (this.isLessAttended) {
            this.setBaseUrl(unattendedBaseUrl);
        } else {
            this.setBaseUrl(this.getSetupUtilityBean().getDefaultBaseUrl(this.requestUrl, this.servletPath));
        }
        return "input";
    }

    public String execute() throws Exception {
        try {
            this.getSetupUtilityBean().setupGeneralConfiguration(this.instanceName, this.baseUrl, this.configDir, this.buildWorkingDir, this.buildDir, this.artifactsDir, this.brokerURI, this.repositoryLogsDir, this);
            if (this.hasAnyErrors()) {
                return "error";
            }
            this.getSetupPersister().progessSetupStep();
            return "success";
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.addActionError(this.getText("error.recording.default.paths.to.system"));
            return "error";
        }
    }

    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.baseUrl)) {
            this.addFieldError("baseUrl", this.getText("config.server.baseUrl.error.required"));
        }
        if (StringUtils.isEmpty((CharSequence)this.configDir)) {
            this.addFieldError("configDir", this.getText("setup.install.configuration.directory.required"));
        }
        if (StringUtils.isEmpty((CharSequence)this.buildDir)) {
            this.addFieldError("buildDir", this.getText("setup.install.build.directory.required"));
        }
        if (StringUtils.isEmpty((CharSequence)this.buildWorkingDir)) {
            this.addFieldError(BUILD_WORKING_DIR, this.getText("config.server.buildDirectory.error.required"));
        }
        if (StringUtils.isEmpty((CharSequence)this.repositoryLogsDir)) {
            this.addFieldError("repositoryLogsDir", this.getText("config.server.repositoryLogs.error.required"));
        }
        if (StringUtils.isEmpty((CharSequence)this.artifactsDir)) {
            this.addFieldError("artifactsDir", this.getText("config.server.artifactsDirectory.error.required"));
        }
        if (this.isRemoteAllowed()) {
            if (StringUtils.isEmpty((CharSequence)this.brokerURI)) {
                this.addFieldError("brokerUrl", this.getText("setup.install.brokerUrl.required"));
            } else {
                try {
                    URI broker = new URI(this.brokerURI);
                    if (broker.getScheme() == null) {
                        this.addFieldError("brokerUrl", this.getText("setup.install.brokerUrl.invalid"));
                    }
                }
                catch (URISyntaxException e) {
                    this.addFieldError("brokerUrl", "Malformed broker url. " + e.getMessage());
                }
            }
        }
    }

    public boolean isLessAttended() {
        return this.isLessAttended;
    }

    public boolean isRemoteAllowed() {
        return this.getBambooLicenseManager().getAllowedNumberOfRemoteAgents() > 0;
    }

    @Override
    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String url) {
        this.baseUrl = url;
    }

    public String getConfigDir() {
        return this.configDir;
    }

    public void setConfigDir(String configDir) {
        this.configDir = configDir;
    }

    public String getBuildDir() {
        return this.buildDir;
    }

    public void setBuildDir(String buildDir) {
        this.buildDir = buildDir;
    }

    public String getBuildWorkingDir() {
        return this.buildWorkingDir;
    }

    public void setBuildWorkingDir(String buildWorkingDir) {
        this.buildWorkingDir = buildWorkingDir;
    }

    public String getArtifactsDir() {
        return this.artifactsDir;
    }

    public void setArtifactsDir(String artifactsDir) {
        this.artifactsDir = artifactsDir;
    }

    public String getBrokerUrl() {
        return this.brokerURI;
    }

    public void setBrokerUrl(String brokerURI) {
        this.brokerURI = brokerURI;
    }

    public String getRepositoryLogsDir() {
        return this.repositoryLogsDir;
    }

    public void setRepositoryLogsDir(String repositoryLogsDir) {
        this.repositoryLogsDir = repositoryLogsDir;
    }

    public String getVersion() {
        return BuildUtils.getCurrentVersion();
    }

    @Override
    public BambooLicenseManager getBambooLicenseManager() {
        if (this.bambooLicenseManager == null) {
            this.bambooLicenseManager = (BambooLicenseManager)BootstrapUtils.getBootstrapContext().getBean("bambooLicenseManager");
        }
        return this.bambooLicenseManager;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.requestUrl = request.getRequestURL().toString();
        this.servletPath = request.getServletPath();
    }
}

