/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.setup;

import com.atlassian.bamboo.ww2.actions.setup.AbstractSetupAction;
import com.atlassian.bamboo.ww2.aware.JsonStatusProvider;
import com.atlassian.config.ConfigurationException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import org.apache.struts2.util.ServletContextAware;

public class SetupEmbeddedDatabaseAction
extends AbstractSetupAction
implements ServletContextAware,
JsonStatusProvider {
    private static final Logger log = Logger.getLogger(SetupEmbeddedDatabaseAction.class);
    private static final AtomicBoolean isAlreadyExecuted = new AtomicBoolean();
    private boolean completed = false;
    private ServletContext servletContext;

    public String execute() throws ConfigurationException {
        if (isAlreadyExecuted.compareAndSet(false, true)) {
            return this.executeOnce();
        }
        throw new IllegalStateException("Tried to execute embedded database setup more than once");
    }

    private String executeOnce() throws ConfigurationException {
        this.getSetupUtilityBean().setupEmbeddedDatabase(this.servletContext, this);
        if (this.hasAnyErrors()) {
            log.info((Object)"An error has occurred during Embedded database");
            this.completed = true;
            return "error";
        }
        log.info((Object)"Embedded database has been set up");
        this.completed = true;
        this.getSetupPersister().progessSetupStep();
        return "success";
    }

    public void setServletContext(ServletContext context) {
        this.servletContext = context;
    }

    public String getWaitMessage() {
        return this.getText("setup.install.wait.database");
    }

    public int getWaitStep() {
        return 2;
    }

    @Override
    public JSONObject getJsonStatus() throws Exception {
        JSONObject json = new JSONObject();
        json.put("completed", this.completed);
        return json;
    }
}

