/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.setup;

import com.atlassian.bamboo.ww2.actions.setup.AbstractSetupAction;
import com.atlassian.bamboo.ww2.actions.setup.SetupInvoker;
import com.atlassian.bamboo.ww2.aware.JsonStatusProvider;
import com.atlassian.config.util.BootstrapUtils;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.concurrent.Callable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.util.ServletContextAware;

public class SetupDefaultsAction
extends AbstractSetupAction
implements ServletRequestAware,
ServletContextAware,
JsonStatusProvider {
    private static final Logger log = Logger.getLogger(SetupDefaultsAction.class);
    private String failedAction;
    private String customAction;
    private String requestUrl;
    private String servletPath;
    private ServletContext servletContext;
    private boolean completed = false;
    private boolean setupStageFailed;
    private SetupInvoker setupInvoker;

    public String general() throws Exception {
        return this.getSetupInvoker().execute(new SetupDefaultGeneral()) ? "success" : "error";
    }

    public String database() throws Exception {
        return this.getSetupInvoker().execute(new SetupDefaultDatabase()) ? "success" : "error";
    }

    private void reportSetupFailure(String msg, String failedAction, String customAction) {
        log.error((Object)msg);
        this.failedAction = failedAction;
        this.customAction = customAction;
        this.completed = true;
    }

    public SetupInvoker getSetupInvoker() {
        if (this.setupInvoker == null) {
            this.setupInvoker = (SetupInvoker)BootstrapUtils.getBootstrapContext().getBean("setupInvoker");
        }
        return this.setupInvoker;
    }

    public String getFailedAction() {
        return this.failedAction;
    }

    public String getCustomAction() {
        return this.customAction;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.requestUrl = request.getRequestURL().toString();
        this.servletPath = request.getServletPath();
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public JSONObject getJsonStatus() throws Exception {
        JSONObject json = new JSONObject();
        json.put("completed", this.completed);
        return json;
    }

    public String getWaitMessage() {
        return this.getText("setup.install.wait.general");
    }

    public int getWaitStep() {
        return 2;
    }

    private class SetupDefaultDatabase
    implements Callable<Boolean> {
        private SetupDefaultDatabase() {
        }

        @Override
        public Boolean call() throws Exception {
            if (!SetupDefaultsAction.this.getSetupPersister().getCurrentStep().equals("setupDefaultDatabase")) {
                return false;
            }
            try {
                log.info((Object)"Setting up the embedded database...");
                SetupDefaultsAction.this.getSetupUtilityBean().setupEmbeddedDatabase(SetupDefaultsAction.this.servletContext, SetupDefaultsAction.this);
                SetupDefaultsAction.this.setupStageFailed = SetupDefaultsAction.this.hasAnyErrors();
                if (!SetupDefaultsAction.this.setupStageFailed) {
                    log.info((Object)"Database setup complete.");
                    SetupDefaultsAction.this.getSetupPersister().progessSetupStep();
                    SetupDefaultsAction.this.completed = true;
                }
            }
            catch (Exception e) {
                SetupDefaultsAction.this.addActionError(e.toString());
                log.error((Object)"Exception during database setup", (Throwable)e);
                SetupDefaultsAction.this.setupStageFailed = true;
            }
            if (SetupDefaultsAction.this.setupStageFailed) {
                SetupDefaultsAction.this.reportSetupFailure("Database setup failed.", "setupDefaultDatabase", "setupDatabase");
                return false;
            }
            return true;
        }
    }

    private class SetupDefaultGeneral
    implements Callable<Boolean> {
        private SetupDefaultGeneral() {
        }

        @Override
        public Boolean call() throws Exception {
            if (!SetupDefaultsAction.this.getSetupPersister().getCurrentStep().equals("setupDefaultGeneral")) {
                return false;
            }
            try {
                SetupDefaultsAction.this.getSetupUtilityBean().setupDefaultGeneralConfiguration(SetupDefaultsAction.this.requestUrl, SetupDefaultsAction.this.servletPath, SetupDefaultsAction.this);
                SetupDefaultsAction.this.setupStageFailed = SetupDefaultsAction.this.hasAnyErrors();
                if (!SetupDefaultsAction.this.setupStageFailed) {
                    log.info((Object)"General configuration setup complete.");
                    SetupDefaultsAction.this.getSetupPersister().progessSetupStep();
                }
            }
            catch (Exception e) {
                SetupDefaultsAction.this.addActionError(e.toString());
                log.error((Object)"Exception during general setup", (Throwable)e);
                SetupDefaultsAction.this.setupStageFailed = true;
            }
            if (SetupDefaultsAction.this.setupStageFailed) {
                SetupDefaultsAction.this.reportSetupFailure("General configuration setup failed.", "setupDefaultGeneral", "setupGeneralConfiguration");
                return false;
            }
            return new SetupDefaultDatabase().call();
        }
    }
}

