/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.setup;

import com.atlassian.bamboo.ww2.actions.setup.AbstractSetupAction;
import com.atlassian.bamboo.ww2.actions.setup.LessAttendedSetup;
import com.atlassian.bamboo.ww2.aware.JsonStatusProvider;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.config.db.DatabaseDetails;
import com.atlassian.core.util.PairType;
import com.atlassian.upgrade.UpgradeException;
import com.atlassian.xwork.ParameterSafe;
import com.google.common.collect.Lists;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.util.ServletContextAware;

public class SetupDatabaseConnectionAction
extends AbstractSetupAction
implements ServletContextAware,
JsonStatusProvider {
    private static final Logger log = Logger.getLogger(SetupDatabaseConnectionAction.class);
    private static final String JDBC = "jdbcConnection";
    private static final String DATASOURCE = "datasourceConnection";
    private static final String TEST_TABLE_NAME = "TEST_TABLE_AXN54123G";
    private static final String CREATE_TEST_TABLE = "CREATE TABLE IF NOT EXISTS TEST_TABLE_AXN54123G (uuk INT NOT NULL)";
    private static final String DROP_TEST_TABLE = "DROP TABLE IF EXISTS TEST_TABLE_AXN54123G";
    private static final String TEST_TABLE_IS_INNODB = "SHOW TABLE STATUS FROM `%s` WHERE NAME = 'TEST_TABLE_AXN54123G' AND ENGINE = 'InnoDB'";
    private String selectedDatabase;
    private String connectionChoice = "jdbcConnection";
    private boolean dataOverwrite;
    private String datasourceName;
    private DatabaseDetails dbDetails = new DatabaseDetails();
    private ServletContext servletContext;
    private boolean completed = false;

    public String input() throws Exception {
        this.dbDetails = DatabaseDetails.getDefaults((String)this.selectedDatabase);
        String password = LessAttendedSetup.getDatabasePassword();
        if (password != null) {
            this.dbDetails.setUserName(LessAttendedSetup.getDatabaseUser());
            this.dbDetails.setDatabaseUrl(this.dbDetails.getDatabaseUrl() + "_aws");
            log.info((Object)"Following unattended path");
            return "unattended";
        }
        return "input";
    }

    private void validateFields() {
        log.info((Object)"Validating database configuration...");
        String password = LessAttendedSetup.getDatabasePassword();
        if (password != null) {
            this.dbDetails.setPassword(password);
        }
        this.validateDatabase();
        if (this.hasAnyErrors()) {
            log.info((Object)("Database configuration is invalid: " + this.getFieldErrors()));
            this.completed = true;
        } else {
            log.info((Object)"Database configuration is valid.");
        }
    }

    public String execute() {
        this.validateFields();
        if (this.hasAnyErrors()) {
            return "error";
        }
        if (this.connectionChoice.equals(JDBC)) {
            this.getSetupUtilityBean().setupStandardDatabase(this.selectedDatabase, this.dbDetails, this.servletContext, this);
        } else {
            this.getSetupUtilityBean().setupDatasourceDatabase(this.selectedDatabase, this.dbDetails, this.datasourceName, this.servletContext, this);
        }
        if (this.hasAnyErrors()) {
            this.completed = true;
            if (this.getActionErrors().stream().anyMatch(error -> error.contains(UpgradeException.class.getCanonicalName()))) {
                return "dbValidationError";
            }
            return "error";
        }
        this.getSetupPersister().progessSetupStep();
        this.completed = true;
        return "success";
    }

    private void validateDatabase() {
        if ("other".equals(this.selectedDatabase) && StringUtils.isBlank((CharSequence)this.dbDetails.getDialect())) {
            this.addFieldError("dbConfigInfo.dialect", this.getText("setup.install.database.external.error.unknown.dialect"));
        }
        if (this.connectionChoice.equals(JDBC)) {
            this.validateJDBCFields();
        } else {
            this.validateDatasourceFields();
        }
        if (this.getFieldErrors().isEmpty()) {
            log.info((Object)("Validating connection to url: [" + this.dbDetails.getDatabaseUrl() + "]"));
            try (Connection connection = this.createConnection();){
                if (!this.dataOverwrite && this.getBootstrapManager().databaseContainsExistingData(connection)) {
                    this.addActionError(this.getText("setup.install.database.external.error.contains.data"));
                }
                if (this.selectedDatabase.equals("mysql") && !this.createTableUsesInnoDB(connection)) {
                    String[] helpLink = new String[]{this.getText("help.prefix") + this.getText("db.mysql")};
                    this.addActionError(this.getText("setup.install.database.external.mysql.innodb", helpLink));
                }
            }
            catch (Exception e) {
                this.addActionError(this.getText("setup.install.database.external.error.access") + e.getMessage());
                log.error((Object)("Unable to connect to database: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private Connection createConnection() throws BootstrapException {
        return this.connectionChoice.equals(JDBC) ? this.getBootstrapManager().getTestDatabaseConnection(this.dbDetails) : this.getBootstrapManager().getTestDatasourceConnection(this.datasourceName);
    }

    /*
     * Exception decompiling
     */
    private boolean createTableUsesInnoDB(Connection connection) throws BootstrapException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void validateDatasourceFields() {
        if (StringUtils.isBlank((CharSequence)this.datasourceName)) {
            this.addFieldError("datasourceName", this.getText("setup.install.database.external.error.datasource.empty"));
        }
    }

    private void validateJDBCFields() {
        if (StringUtils.isBlank((CharSequence)this.dbDetails.getDriverClassName())) {
            this.addFieldError("dbConfigInfo.driverClassName", this.getText("setup.install.database.external.error.driver.class.empty"));
        } else if (!this.dbDetails.checkDriver()) {
            this.addFieldError("dbConfigInfo.driverClassName", this.getText("setup.install.database.external.error.driver.class.unknown"));
        }
        if (StringUtils.isBlank((CharSequence)this.dbDetails.getDatabaseUrl())) {
            this.addFieldError("dbConfigInfo.databaseUrl", this.getText("setup.install.database.external.error.url.empty"));
        }
        if (StringUtils.isBlank((CharSequence)this.dbDetails.getUserName())) {
            this.addFieldError("dbConfigInfo.userName", this.getText("setup.install.database.external.error.username.empty"));
        }
    }

    public List<PairType> getConnectionTypes() {
        return Lists.newArrayList((Object[])new PairType[]{new PairType((Serializable)((Object)JDBC), (Serializable)((Object)this.getText("setup.install.database.connection.jdbc"))), new PairType((Serializable)((Object)DATASOURCE), (Serializable)((Object)this.getText("setup.install.database.connection.jndi")))});
    }

    public String getSelectedDatabase() {
        return this.selectedDatabase;
    }

    public void setSelectedDatabase(String selectedDatabase) {
        this.selectedDatabase = selectedDatabase;
    }

    public String getConnectionChoice() {
        return this.connectionChoice;
    }

    public void setConnectionChoice(String connectionChoice) {
        this.connectionChoice = connectionChoice;
    }

    public boolean getDataOverwrite() {
        return this.dataOverwrite;
    }

    public void setDataOverwrite(boolean dataOverwrite) {
        this.dataOverwrite = dataOverwrite;
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public void setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
    }

    @ParameterSafe
    public DatabaseDetails getDbConfigInfo() {
        return this.dbDetails;
    }

    public void setDbConfigInfo(DatabaseDetails dbDetails) {
        this.dbDetails = dbDetails;
    }

    public void setServletContext(ServletContext context) {
        this.servletContext = context;
    }

    public String getWaitMessage() {
        return this.getText("setup.install.wait.database");
    }

    public int getWaitStep() {
        return 2;
    }

    @Override
    public JSONObject getJsonStatus() throws Exception {
        JSONObject json = new JSONObject();
        json.put("completed", this.completed);
        return json;
    }
}

