/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.setup;

import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.ww2.actions.setup.AbstractSetupAction;
import com.atlassian.bamboo.ww2.actions.setup.LessAttendedSetup;
import com.atlassian.config.db.DatabaseList;
import com.atlassian.core.util.PairType;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;

public class SetupDatabaseAction
extends AbstractSetupAction {
    private static final Logger log = Logger.getLogger(SetupDatabaseAction.class);
    private List<PairType> databases;
    private String dbChoice = "embeddedDb";
    private String selectedDatabase;
    private static final String STANDARD = "standardDb";
    private static final String EMBEDDED = "embeddedDb";

    public String input() throws Exception {
        String database = LessAttendedSetup.getDbmsType();
        if (database != null) {
            this.setSelectedDatabase(database);
            log.info((Object)"Following unattended path");
            return "unattended";
        }
        return super.input();
    }

    public String execute() {
        if (this.dbChoice.equals(STANDARD)) {
            return STANDARD;
        }
        return EMBEDDED;
    }

    public List<PairType> getDatabases() {
        if (this.databases == null) {
            DatabaseList databaseList = new DatabaseList();
            this.databases = Lists.transform((List)databaseList.getDatabases(), databaseType -> new PairType((Serializable)((Object)databaseType.getKey()), (Serializable)((Object)databaseType.getValue())));
            if (SystemProperty.ALLOW_UNSUPPORTED_DB.getValue(false)) {
                this.databases.add(new PairType((Serializable)((Object)"other"), (Serializable)((Object)"Unsupported Database")));
            }
        }
        return this.databases;
    }

    public List<PairType> getDatabaseOptions() {
        return Lists.newArrayList((Object[])new PairType[]{new PairType((Serializable)((Object)EMBEDDED), (Serializable)((Object)EMBEDDED)), new PairType((Serializable)((Object)STANDARD), (Serializable)((Object)STANDARD))});
    }

    public String getDbChoice() {
        return this.dbChoice;
    }

    public void setDbChoice(String dbChoice) {
        this.dbChoice = dbChoice;
    }

    public String getSelectedDatabase() {
        return this.selectedDatabase;
    }

    public void setSelectedDatabase(String selectedDatabase) {
        this.selectedDatabase = selectedDatabase;
    }
}

