/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.setup;

import com.atlassian.bamboo.configuration.SystemInfo;
import com.atlassian.bamboo.configuration.SystemInfoImpl;
import com.atlassian.bamboo.ww2.actions.setup.AbstractSetupAction;
import com.atlassian.bamboo.ww2.actions.setup.SetupUtilityBean;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;

public class SetupAdminUserAction
extends AbstractSetupAction {
    private String username;
    private String password;
    private String confirmPassword;
    private String fullName;
    private String email;
    private SystemInfo systemInfo;
    private SetupUtilityBean setupUtilityBean;

    public String input() throws Exception {
        this.systemInfo = new SystemInfoImpl();
        return super.input();
    }

    public String execute() throws Exception {
        this.setupUtilityBean.setupUser(this.username, this.password, this.email, this.fullName, this);
        this.loginAdminAccount();
        if (this.hasErrors()) {
            return "error";
        }
        return "success";
    }

    private void loginAdminAccount() throws AuthenticatorException {
        SecurityConfig securityConfig = SecurityConfigFactory.getInstance(null);
        Authenticator authenticator = securityConfig.getAuthenticator();
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (request != null && response != null && !authenticator.login(request, response, this.getUsername(), this.getPassword())) {
            throw new SecurityException("Could not login admin user '" + this.getUsername() + "'");
        }
    }

    public void validate() {
        super.validate();
        if (IdentifierUtils.hasLeadingOrTrailingWhitespace((String)this.getUsername())) {
            this.addFieldError("username", this.getText("user.username.error.invalid"));
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public SystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    public void setSetupUtilityBean(SetupUtilityBean setupUtilityBean) {
        this.setupUtilityBean = setupUtilityBean;
    }
}

