/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.setup;

import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.ww2.actions.setup.AbstractSetupAction;
import com.atlassian.plugin.util.JavaVersionUtils;
import org.apache.log4j.Logger;

public class SelectSetupStepAction
extends AbstractSetupAction {
    private static final Logger log = Logger.getLogger(SelectSetupStepAction.class);
    private static final String RESULT_PRECONDITIONS_FAILED = "checklist";
    private String currentStepActionName;

    public String execute() {
        if (!this.isEverythingOk()) {
            return RESULT_PRECONDITIONS_FAILED;
        }
        this.currentStepActionName = "/setup/" + this.getSetupPersister().getCurrentStep() + ".action";
        log.info((Object)("Current setup step is " + this.currentStepActionName));
        return "success";
    }

    public String getCurrentStep() {
        return this.currentStepActionName;
    }

    public boolean isEverythingOk() {
        return this.isJdkCorrect() && this.isApplicationHomeOk();
    }

    public String getMinJdkVersion() {
        return BuildUtils.getMinJdkVersion();
    }

    public boolean isJdkCorrect() {
        return JavaVersionUtils.satisfiesMinVersion((float)JavaVersionUtils.resolveVersionFromString((String)this.getMinJdkVersion()).floatValue());
    }

    public boolean isApplicationHomeOk() {
        return this.getBootstrapManager().isApplicationHomeValid();
    }

    public String getJdkName() {
        return System.getProperty("java.vendor") + " - " + System.getProperty("java.version");
    }

    public String getApplicationHome() {
        return this.getBootstrapManager().getApplicationHome();
    }
}

