/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.setup;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

final class LessAttendedSetup {
    private static final Logger log = Logger.getLogger(LessAttendedSetup.class);
    private static final SetupSettings SETUP_SETTINGS = new SetupSettings();

    private LessAttendedSetup() {
    }

    public static String getLicense() {
        return null;
    }

    @Nullable
    public static String getSetupType() {
        return SETUP_SETTINGS.setupType;
    }

    public static String getBaseUrl() {
        return SETUP_SETTINGS.baseUrl;
    }

    public static String getDbmsType() {
        return SETUP_SETTINGS.dbmsType;
    }

    public static String getDatabaseUser() {
        return SETUP_SETTINGS.databaseUser;
    }

    public static String getDatabasePassword() {
        return SETUP_SETTINGS.databasePassword;
    }

    public static Boolean shouldImportExistingData() {
        return SETUP_SETTINGS.shouldImportExistingData;
    }

    private static class SetupSettings {
        private static final String BAMBOO_SETUP_SETTINGS = "bamboo.setup.settings";
        private String baseUrl;
        private String dbmsType;
        private String databaseUser;
        private String databasePassword;
        private Boolean shouldImportExistingData;
        private String setupType;

        private SetupSettings() {
            Properties properties = new Properties();
            String propertyFile = System.getProperties().getProperty(BAMBOO_SETUP_SETTINGS);
            if (propertyFile == null) {
                return;
            }
            try {
                properties.load(Files.newBufferedReader(Paths.get(propertyFile, new String[0])));
                for (Field field : this.getClass().getDeclaredFields()) {
                    String configValueStr = properties.getProperty(field.getName());
                    if (configValueStr == null) continue;
                    field.setAccessible(true);
                    Object configValue = SetupSettings.valueOf(configValueStr, field.getType());
                    log.warn((Object)(field + " = " + properties.getProperty(field.getName()) + " => " + configValue));
                    field.set(this, configValue);
                }
            }
            catch (IOException | IllegalAccessException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        private static <T> T valueOf(@Nullable String string, Class<T> aClass) {
            if (aClass.equals(Boolean.class) || aClass.equals(Boolean.TYPE)) {
                return (T)BooleanUtils.toBooleanObject((String)string);
            }
            return (T)string;
        }
    }
}

