/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.setup;

import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.upgrade.UpgradeLauncher;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.ww2.actions.setup.AbstractSetupAction;
import com.atlassian.bamboo.ww2.actions.setup.SetupUtilityBean;
import com.atlassian.bamboo.ww2.aware.JsonStatusProvider;
import com.atlassian.config.setup.SetupException;
import com.google.common.base.Joiner;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import org.apache.struts2.util.ServletContextAware;
import org.springframework.beans.factory.annotation.Autowired;

public class FinishSetupAction
extends AbstractSetupAction
implements JsonStatusProvider,
ServletContextAware {
    private static final Logger log = Logger.getLogger(FinishSetupAction.class);
    private AgentManager agentManager;
    private ServletContext servletContext;
    @Autowired
    private SetupUtilityBean setupUtilityBean;
    private boolean completed = false;

    public String execute() throws Exception {
        try {
            this.setupAgentsSecurityToken();
            this.agentManager.createDefaultAgent();
            this.getSetupPersister().progessSetupStep();
            this.getSetupPersister().finishSetup();
            this.getBootstrapManager().publishConfiguration();
            UpgradeLauncher.upgradeAndStartBamboo(this.servletContext, true);
            log.info((Object)"Bamboo Setup Complete");
        }
        catch (Throwable e) {
            this.completed = true;
            log.error((Object)"Failed to set up Bamboo", e);
            return "error";
        }
        this.completed = true;
        return "success";
    }

    private void setupAgentsSecurityToken() throws SetupException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        this.setupUtilityBean.setupAgentsSecurityToken((ErrorCollection)errorCollection, false);
        if (errorCollection.hasAnyErrors()) {
            throw new SetupException("Error setting up agent security token settings: " + Joiner.on((String)",").join((Iterable)errorCollection.getErrorMessages()));
        }
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public String getWaitMessage() {
        return this.getText("setup.install.wait.finalise");
    }

    public int getWaitStep() {
        return 4;
    }

    public String getCompletedUrl() {
        return "/start.action";
    }

    @Override
    public JSONObject getJsonStatus() throws Exception {
        JSONObject json = new JSONObject();
        json.put("completed", this.completed);
        return json;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

