/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.rss;

import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.rss.RssFeedBuilder;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.sun.syndication.feed.synd.SyndFeed;

public class AllBuildsRssFeedAction
extends BambooActionSupport {
    private static final int MAX_RSS_FEED_ENTRIES = 30;
    private static final String FAILED_BUILDS = "rssFailed";
    private String buildKey;
    private String feedType;
    private ResultsSummaryManager resultsSummaryManager;
    private RssFeedBuilder rssFeedBuilder;

    public String execute() {
        return "rss";
    }

    public SyndFeed getSyndFeed() {
        SyndFeed syndFeed;
        if (this.buildKey == null) {
            if (FAILED_BUILDS.equals(this.feedType)) {
                syndFeed = this.rssFeedBuilder.createFeed(this.resultsSummaryManager.getLatestFailedResultSummaries(), 30);
                syndFeed.setDescription(this.createFeedDescription(null, true, true));
                syndFeed.setTitle(this.createFeedTitle(null, true, true));
            } else {
                syndFeed = this.rssFeedBuilder.createFeed(this.resultsSummaryManager.getLatestResultSummaries(), 30);
                syndFeed.setTitle(this.createFeedTitle(null, false, true));
                syndFeed.setDescription(this.createFeedDescription(null, false, true));
            }
        } else {
            Plan plan = this.planManager.getPlanByKey(this.buildKey);
            if (plan == null) {
                syndFeed = this.rssFeedBuilder.createErrorFeed("Plan key was invalid: " + this.buildKey);
            } else if (FAILED_BUILDS.equals(this.feedType)) {
                syndFeed = this.rssFeedBuilder.createFeed(this.resultsSummaryManager.getLastNFailedResultsSummaries(plan, 30), 30);
                syndFeed.setTitle(this.createFeedTitle(plan.getBuildName(), true, false));
                syndFeed.setDescription(this.createFeedDescription(plan.getBuildName(), true, false));
            } else {
                syndFeed = this.rssFeedBuilder.createFeed(this.resultsSummaryManager.getLastNResultsSummaries((ImmutablePlan)plan, 30), 30);
                syndFeed.setTitle(this.createFeedTitle(plan.getBuildName(), false, false));
                syndFeed.setDescription(this.createFeedDescription(plan.getBuildName(), false, false));
            }
        }
        return syndFeed;
    }

    private String createFeedTitle(String buildName, boolean isFailedBuildFeed, boolean isMultiBuildFeed) {
        StringBuilder buffer = new StringBuilder("Bamboo ");
        if (isFailedBuildFeed) {
            buffer.append("failed ");
        }
        buffer.append("build results feed for ");
        if (isMultiBuildFeed) {
            buffer.append("all builds");
        } else {
            buffer.append("the ").append(buildName).append(" build");
        }
        return buffer.toString();
    }

    private String createFeedDescription(String buildName, boolean isFailedBuildFeed, boolean isMultiBuildFeed) {
        StringBuilder buffer = new StringBuilder("This feed is updated whenever ");
        if (isMultiBuildFeed) {
            buffer.append("a build ");
        } else {
            buffer.append("the ").append(buildName).append(" build ");
        }
        if (isFailedBuildFeed) {
            buffer.append("build fails");
        } else {
            buffer.append("gets built");
        }
        return buffer.toString();
    }

    public String getBuildKey() {
        return this.buildKey;
    }

    public void setBuildKey(String buildKey) {
        this.buildKey = buildKey;
    }

    public String getFeedType() {
        return this.feedType;
    }

    public void setFeedType(String feedType) {
        this.feedType = feedType;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public void setRssFeedBuilder(RssFeedBuilder rssFeedBuilder) {
        this.rssFeedBuilder = rssFeedBuilder;
    }
}

