/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.reports;

import com.atlassian.bamboo.charts.ChartManager;
import com.atlassian.bamboo.charts.ChartParameterHelper;
import com.atlassian.bamboo.filter.Pager;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.plugin.descriptor.ReportCollectorModuleDescriptor;
import com.atlassian.bamboo.reports.collector.ReportCollector;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.web.utils.ActionParamHandlingUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.actions.reports.ReportHelper;
import com.atlassian.bamboo.ww2.aware.PaginationAware;
import com.atlassian.plugin.ModuleDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jfree.data.time.TimeTableXYDataset;

public class ViewReport
extends BambooActionSupport
implements PaginationAware {
    private static final Logger log = Logger.getLogger(ViewReport.class);
    private static final String LABEL_TARGET_PARAMETER = "labelTarget";
    private static final Collection<String> LABEL_AWARE_REPORT_KEYS = Arrays.asList("com.atlassian.bamboo.plugin.system.reports:labelUsageCount", "com.atlassian.bamboo.plugin.system.reports:labelUsageRatio", "com.atlassian.bamboo.plugin.system.reports:ratioOfFailureWithLabelUsage");
    private List<ResultsSummary> resultsList;
    private TimeTableXYDataset dataset;
    private List<Long> buildIds;
    private String groupByPeriod = "AUTO";
    private String reportKey;
    private String dateFilter = "None";
    private String dateFrom;
    private String dateTo;
    private String labelTarget;
    private String resolvedAutoPeriod;
    private Collection<ImmutableTopLevelPlan> availablePlans;
    private List<ReportCollectorModuleDescriptor> availableReports;
    private Map<String, String> availableGroupBy;
    private Map<String, String> availableDateFilter;
    private Pager pager;
    private ChartManager chartManager;
    private boolean useSession = true;
    private boolean hideHeader;

    public String view() throws Exception {
        Map<String, String[]> contextMap;
        if (this.useSession) {
            log.trace((Object)"Getting report searcher context from HTTP session");
            contextMap = this.getBambooSession().getReportSearcherContext();
        } else {
            log.trace((Object)"Report searcher context ignored, not taken from HTTP session");
            contextMap = null;
        }
        if (contextMap != null) {
            String report;
            if (contextMap.containsKey("buildIds")) {
                List<Long> buildIds = Arrays.stream((Object[])contextMap.get("buildIds")).map(Long::valueOf).collect(Collectors.toList());
                this.setBuildIds(buildIds);
            }
            if ((report = this.chartManager.getReportKey(contextMap)) != null) {
                this.setReportKey(report);
            }
            if (contextMap.containsKey("groupByPeriod")) {
                this.setGroupByPeriod(ChartParameterHelper.getFromContext(contextMap, (String)"groupByPeriod"));
            }
            if (contextMap.containsKey("dateFilter")) {
                this.setDateFilter(ChartParameterHelper.getFromContext(contextMap, (String)"dateFilter"));
            }
            if (contextMap.containsKey("dateFrom")) {
                this.setDateFrom(ChartParameterHelper.getFromContext(contextMap, (String)"dateFrom"));
            }
            if (contextMap.containsKey("dateTo")) {
                this.setDateTo(ChartParameterHelper.getFromContext(contextMap, (String)"dateTo"));
            }
            if (contextMap.containsKey(LABEL_TARGET_PARAMETER)) {
                this.setLabelTarget(ChartParameterHelper.getFromContext(contextMap, (String)LABEL_TARGET_PARAMETER));
            }
            List buildIds = (List)ObjectUtils.defaultIfNull(this.getBuildIds(), Collections.emptyList());
            log.debug((Object)String.format("Viewing report '%s' for builds: %s", this.getReportKey(), buildIds));
            this.runReport(contextMap);
            return "success";
        }
        return "input";
    }

    public String generate() {
        Map contextMap = ActionParamHandlingUtils.getContextAsStringArrayMap();
        this.runReport(contextMap);
        this.getBambooSession().setReportSearcherContext(contextMap);
        if (!this.hideHeader) {
            return "success";
        }
        return "hideHeader";
    }

    private void runReport(Map<String, String[]> contextMap) {
        String reportKey = this.chartManager.getReportKey(contextMap);
        if (StringUtils.isEmpty((CharSequence)reportKey)) {
            this.addActionError("Report not found for key: " + reportKey);
            return;
        }
        ModuleDescriptor descriptor = this.chartManager.getReport(reportKey);
        if (descriptor == null) {
            this.addActionError("Report for " + reportKey + " not found");
            return;
        }
        this.resultsList = this.chartManager.prepareResultList(contextMap);
        if (this.resultsList.isEmpty()) {
            this.addActionError("No matching results found. Please try selecting a different plan.");
            return;
        }
        ReportCollector collector = this.chartManager.getReportCollector(this.resultsList, contextMap);
        if (collector != null) {
            collector.setResultsList(this.getResultsList());
            collector.setParams(contextMap);
            this.dataset = (TimeTableXYDataset)collector.getDataset();
            this.resolvedAutoPeriod = collector.getPeriodRange();
        } else {
            this.addActionError("An unexpected error occurred.");
        }
    }

    public ModuleDescriptor getSelectedReport() {
        return this.chartManager.getReport(this.getReportKey());
    }

    public Collection<ImmutableTopLevelPlan> getAvailablePlans() {
        if (this.availablePlans == null) {
            this.availablePlans = this.cachedPlanManager.getPlans();
        }
        return this.availablePlans;
    }

    public int getNumberOfProjects() {
        return this.projectManager.getProjects().size();
    }

    public List<ReportCollectorModuleDescriptor> getAvailableReports() {
        if (this.availableReports == null) {
            this.availableReports = this.chartManager.getAvailableReports();
        }
        return this.availableReports;
    }

    public Map<String, String> getAvailableGroupBy() {
        if (this.availableGroupBy == null) {
            this.availableGroupBy = ReportHelper.getGroupByDateOptions();
        }
        return this.availableGroupBy;
    }

    public Map<String, String> getAvailableDateFilter() {
        if (this.availableDateFilter == null) {
            this.availableDateFilter = new LinkedHashMap<String, String>();
            this.availableDateFilter.put("LAST_7_DAYS", "Last 7 Days");
            this.availableDateFilter.put("LAST_30_DAYS", "Last 30 Days");
            this.availableDateFilter.put("LAST_90_DAYS", "Last 90 Days");
        }
        return this.availableDateFilter;
    }

    public String getBuildNameFromKey(String key) {
        ImmutablePlan plan;
        if (PlanKeys.isPlanKey((String)key) && (plan = this.cachedPlanManager.getPlanByKey(PlanKeys.getPlanKey((String)key))) != null) {
            return plan.getName();
        }
        return key;
    }

    public Collection<String> getLabelAwareReportKeys() {
        return LABEL_AWARE_REPORT_KEYS;
    }

    public boolean isUseSession() {
        return this.useSession;
    }

    public void setUseSession(boolean useSession) {
        this.useSession = useSession;
    }

    public boolean isHideHeader() {
        return this.hideHeader;
    }

    public void setHideHeader(boolean hideHeader) {
        this.hideHeader = hideHeader;
    }

    public String getResolvedAutoPeriod() {
        return this.resolvedAutoPeriod;
    }

    public void setResolvedAutoPeriod(String resolvedAutoPeriod) {
        this.resolvedAutoPeriod = resolvedAutoPeriod;
    }

    public List<Long> getBuildIds() {
        return this.buildIds;
    }

    public void setBuildIds(List<Long> buildIds) {
        this.buildIds = buildIds;
    }

    public String getReportKey() {
        return this.reportKey;
    }

    public void setReportKey(String reportKey) {
        this.reportKey = reportKey;
    }

    public String getGroupByPeriod() {
        return this.groupByPeriod;
    }

    public void setGroupByPeriod(String groupByPeriod) {
        this.groupByPeriod = groupByPeriod;
    }

    public String getDateFilter() {
        return this.dateFilter;
    }

    public void setDateFilter(String dateFilter) {
        this.dateFilter = dateFilter;
    }

    public String getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(String dateFrom) {
        this.dateFrom = dateFrom;
    }

    public String getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(String dateTo) {
        this.dateTo = dateTo;
    }

    public String getLabelTarget() {
        return this.labelTarget;
    }

    public void setLabelTarget(String labelTarget) {
        this.labelTarget = labelTarget;
    }

    @Override
    public List<ResultsSummary> getResultsList() {
        return this.resultsList;
    }

    public void setResultsList(List<ResultsSummary> resultsList) {
        this.resultsList = resultsList;
    }

    public TimeTableXYDataset getDataset() {
        return this.dataset;
    }

    @Nullable
    public Double getYValue(int series, int item) {
        double value = this.dataset.getYValue(series, item);
        return Double.isNaN(value) ? null : Double.valueOf(value);
    }

    public void setDataset(TimeTableXYDataset dataset) {
        this.dataset = dataset;
    }

    public Pager getPager() {
        return this.pager;
    }

    public void setPager(Pager pager) {
        this.pager = pager;
    }

    public void setChartManager(ChartManager chartManager) {
        this.chartManager = chartManager;
    }
}

