/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.project.sharedcredentials;

import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.CredentialsManager;
import com.atlassian.bamboo.credentials.CredentialsUsageDetector;
import com.atlassian.bamboo.credentials.SharedCredentialsInJobs;
import com.atlassian.bamboo.credentials.SharedCredentialsInRepositories;
import com.atlassian.bamboo.plugins.web.conditions.ProjectLevelBuildResourcesEnabledCondition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.ww2.actions.project.ProjectActionSupport;
import com.atlassian.bamboo.ww2.aware.ConditionallyAvailable;
import com.atlassian.bamboo.ww2.aware.permissions.ProjectAdminSecurityAware;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@ConditionallyAvailable(condition={ProjectLevelBuildResourcesEnabledCondition.class})
public class DeleteProjectSharedCredentials
extends ProjectActionSupport
implements ProjectAdminSecurityAware {
    protected long credentialsId;
    private Map<VcsRepositoryData, String> planRepositoryDefinitionsMap;
    private Map<VcsRepositoryData, String> planBranchRepositoryDefinitionsMap;
    private Map<String, String> buildTaskDefinitionsMap;
    @Autowired
    protected CredentialsManager credentialsManager;
    @Autowired
    private CredentialsUsageDetector credentialsUsageDetector;

    public String execute() throws Exception {
        CredentialsData credentials = this.credentialsManager.getCredentials(this.credentialsId);
        if (credentials != null && credentials.getProjectId().longValue() == this.getProject().getId()) {
            this.credentialsManager.deleteCredentials(this.credentialsId);
        }
        return "success";
    }

    public String confirm() {
        this.preparePlanAndBranchRepositoryDefinitions();
        this.prepareBuildTaskDefinitions();
        return "success";
    }

    private void preparePlanAndBranchRepositoryDefinitions() {
        SharedCredentialsInRepositories credentialsInProjectRepositories = this.credentialsUsageDetector.getCredentialsInProjectRepositories(Long.valueOf(this.credentialsId), this.getProject());
        this.planRepositoryDefinitionsMap = new HashMap<VcsRepositoryData, String>();
        this.planBranchRepositoryDefinitionsMap = new HashMap<VcsRepositoryData, String>();
        credentialsInProjectRepositories.getPlanRepositories().forEach((e, v) -> v.forEach(r -> this.planRepositoryDefinitionsMap.put((VcsRepositoryData)r, e.getKey())));
        credentialsInProjectRepositories.getPlanBranchRepositories().forEach((e, v) -> v.forEach(r -> this.planBranchRepositoryDefinitionsMap.put((VcsRepositoryData)r, e.getKey())));
    }

    private void prepareBuildTaskDefinitions() {
        SharedCredentialsInJobs credentialsInProjectPlans = this.credentialsUsageDetector.getCredentialsInProjectPlans(Long.valueOf(this.credentialsId), this.getProject());
        this.buildTaskDefinitionsMap = new HashMap<String, String>();
        credentialsInProjectPlans.getJobsWithSharedCredentials().forEach(job -> this.buildTaskDefinitionsMap.put(job.getParent().getName(), job.getPlanKey().toString()));
    }

    public Map<VcsRepositoryData, String> getPlanRepositoryDefinitionsMap() {
        return this.planRepositoryDefinitionsMap;
    }

    public Map<VcsRepositoryData, String> getPlanBranchRepositoryDefinitionsMap() {
        return this.planBranchRepositoryDefinitionsMap;
    }

    public Map<String, String> getBuildTaskDefinitionsMap() {
        return this.buildTaskDefinitionsMap;
    }

    public long getCredentialsId() {
        return this.credentialsId;
    }

    public void setCredentialsId(long credentialsId) {
        this.credentialsId = credentialsId;
    }
}

