/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.project.sharedcredentials;

import com.atlassian.bamboo.configuration.credentials.CredentialsRenderMode;
import com.atlassian.bamboo.configuration.credentials.CredentialsUIConfigBean;
import com.atlassian.bamboo.credentials.CredentialTypeModuleDescriptor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.CredentialsManager;
import com.atlassian.bamboo.plugins.web.conditions.ProjectLevelBuildResourcesEnabledCondition;
import com.atlassian.bamboo.ww2.actions.project.ProjectActionSupport;
import com.atlassian.bamboo.ww2.aware.ConditionallyAvailable;
import com.atlassian.bamboo.ww2.aware.permissions.ProjectAdminSecurityAware;
import com.opensymphony.xwork2.Preparable;
import java.util.Collections;
import java.util.Map;

@ConditionallyAvailable(condition={ProjectLevelBuildResourcesEnabledCondition.class})
public class CreateProjectSharedCredentials
extends ProjectActionSupport
implements Preparable,
ProjectAdminSecurityAware {
    private static final String INVALID_PLUGIN = "invalidPlugin";
    private String createCredentialsKey;
    private String credentialsName;
    private String editHtml;
    private CredentialTypeModuleDescriptor credentialDescriptor;
    private CredentialsManager credentialsManager;
    private CredentialsUIConfigBean credentialsUIConfigBean;

    @Override
    public void prepare() throws Exception {
        this.credentialDescriptor = this.credentialsManager.getCredentialTypeDescriptor(this.createCredentialsKey);
    }

    public String input() throws Exception {
        if (this.hasErrors()) {
            return "error";
        }
        if (this.credentialDescriptor == null) {
            this.addActionError(this.getText("sharedCredentials.add.error.missingPlugin", Collections.singletonList(this.createCredentialsKey)));
            return INVALID_PLUGIN;
        }
        this.editHtml = this.credentialsUIConfigBean.prepareCreateHtml(this.credentialDescriptor, CredentialsRenderMode.SUCCESS);
        return "input";
    }

    public void validate() {
        this.checkFieldXssSafety("credentialsName", this.credentialsName);
        this.validateUniqueName();
        this.validateCredentialDescriptorPresent();
        if (this.credentialDescriptor != null) {
            this.credentialsUIConfigBean.validateCredentialsConfiguration(this.credentialDescriptor, null, this);
            if (this.hasErrors()) {
                this.editHtml = this.credentialsUIConfigBean.prepareCreateHtml(this.credentialDescriptor, CredentialsRenderMode.ERROR);
            }
        }
    }

    public String execute() throws Exception {
        try {
            Map<String, String> credentialsConfig = this.credentialsUIConfigBean.getCredentialsConfigurationMap(this.credentialDescriptor, null);
            this.credentialsManager.createProjectCredentials(this.credentialDescriptor, this.credentialsName, credentialsConfig, Long.valueOf(this.getProject().getId()));
            return "success";
        }
        catch (IllegalArgumentException e) {
            this.addActionError(e);
            return "error";
        }
    }

    private void validateCredentialDescriptorPresent() {
        if (this.credentialDescriptor == null) {
            this.addActionError(this.getText("sharedCredentials.add.error.missingPlugin", Collections.singletonList(this.createCredentialsKey)));
        }
    }

    private void validateUniqueName() {
        CredentialsData existingCredentials = this.credentialsManager.getCredentialsByNameAndProjectId(this.credentialsName, this.getProject().getId());
        if (existingCredentials != null) {
            this.addFieldError("credentialsName", this.getText("sharedCredentials.error.nonUniqueName"));
        }
    }

    public String getCreateCredentialsKey() {
        return this.createCredentialsKey;
    }

    public void setCreateCredentialsKey(String createCredentialsKey) {
        this.createCredentialsKey = createCredentialsKey;
    }

    public String getCredentialsName() {
        return this.credentialsName;
    }

    public void setCredentialsName(String credentialsName) {
        this.credentialsName = credentialsName;
    }

    public String getEditHtml() {
        return this.editHtml;
    }

    public String getCredentialsType() {
        return this.credentialDescriptor.getName();
    }

    public void setCredentialsManager(CredentialsManager credentialsManager) {
        this.credentialsManager = credentialsManager;
    }

    public void setCredentialsUIConfigBean(CredentialsUIConfigBean credentialsUIConfigBean) {
        this.credentialsUIConfigBean = credentialsUIConfigBean;
    }
}

