/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.project.sharedcredentials;

import com.atlassian.bamboo.credentials.CredentialTypeModuleDescriptor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.CredentialsManager;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugins.web.conditions.ProjectLevelBuildResourcesEnabledCondition;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.ww2.actions.project.ProjectActionSupport;
import com.atlassian.bamboo.ww2.aware.ConditionallyAvailable;
import com.atlassian.bamboo.ww2.aware.permissions.ProjectAdminSecurityAware;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

@ConditionallyAvailable(condition={ProjectLevelBuildResourcesEnabledCondition.class})
public class ConfigureProjectSharedCredentials
extends ProjectActionSupport
implements ProjectAdminSecurityAware {
    private CredentialsManager credentialsManager;
    private List<CredentialTypeModuleDescriptor> credentialTypes;
    private Iterable<CredentialsData> credentials;

    public Iterable<CredentialTypeModuleDescriptor> getCredentialTypes() {
        if (this.credentialTypes == null) {
            this.credentialTypes = this.credentialsManager.getCredentialTypeDescriptors();
        }
        return this.credentialTypes;
    }

    public Iterable<CredentialsData> getCredentials(@NotNull String pluginKey) {
        if (this.credentials == null) {
            this.credentials = this.credentialsManager.getProjectCredentials(Long.valueOf(this.getProject().getId()));
        }
        return BambooIterables.stream(this.credentials).filter(BambooPluginUtils.pluginKeyEquals((String)pluginKey)).collect(Collectors.toList());
    }

    public Iterable<CredentialsData> getAllCredentials() {
        if (this.credentials == null) {
            this.credentials = this.credentialsManager.getProjectCredentials(Long.valueOf(this.getProject().getId()));
        }
        return this.credentials;
    }

    public void setCredentialsManager(CredentialsManager credentialsManager) {
        this.credentialsManager = credentialsManager;
    }
}

