/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.project;

import com.atlassian.bamboo.labels.LabelManager;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectStatusHelper;
import com.atlassian.bamboo.project.ProjectStatusHelperImpl;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.ProjectAware;
import com.opensymphony.xwork2.TextProvider;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ViewProject
extends BambooActionSupport
implements ProjectAware {
    private static final Logger log = Logger.getLogger(ViewProject.class);
    private long projectId;
    private String projectKey;
    private Collection<ImmutableTopLevelPlan> projectPlans;
    private Collection<ImmutableChain> projectChains;
    private List<ImmutableTopLevelPlan> plans;
    private ProjectStatusHelper projectStatusHelper;
    private LabelManager labelManager;
    private Set<Long> plansWithBranches;
    private ChainBranchManager chainBranchManager;

    public String execute() throws Exception {
        if (this.getProject() == null) {
            this.addActionError(String.format("Could not find the \"%s\" project", this.getProjectKey()));
            return "error";
        }
        return "success";
    }

    public ProjectStatusHelper getProjectStatusHelper() {
        if (this.projectStatusHelper == null) {
            this.projectStatusHelper = new ProjectStatusHelperImpl(this.getProjectPlans(), (TextProvider)this);
        }
        return this.projectStatusHelper;
    }

    public Collection<ImmutableTopLevelPlan> getProjectPlans() {
        if (this.projectPlans == null) {
            this.projectPlans = this.cachedPlanManager.getPlansByProject(this.getProject(), ImmutableTopLevelPlan.class);
        }
        return this.projectPlans;
    }

    public Collection<ImmutableChain> getProjectChains() {
        if (this.projectChains == null) {
            this.projectChains = this.cachedPlanManager.getPlansByProject(this.getProject(), ImmutableChain.class);
        }
        return this.projectChains;
    }

    @Override
    @Nullable
    public Project getProject() {
        if (StringUtils.isNotBlank((CharSequence)this.projectKey)) {
            return this.projectManager.getProjectByKey(this.projectKey);
        }
        return this.projectManager.getProjectById(this.getProjectId());
    }

    public boolean isFavourite(ImmutableTopLevelPlan plan) {
        return this.labelManager.isFavourite((ImmutablePlan)plan, this.getUser());
    }

    public List<ImmutableTopLevelPlan> getPlans() {
        if (this.plans == null) {
            this.plans = Comparators.getNameProviderCaseInsensitiveOrdering().sortedCopy((Iterable)this.cachedPlanManager.getPlansByProject(this.getProject(), ImmutableTopLevelPlan.class));
        }
        return this.plans;
    }

    public boolean hasBranches(ImmutableTopLevelPlan plan) {
        if (this.plansWithBranches == null) {
            this.plansWithBranches = this.chainBranchManager.getPlansWithBranches();
        }
        return this.plansWithBranches.contains(plan.getId());
    }

    public long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(long projectId) {
        this.projectId = projectId;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public void setChainBranchManager(ChainBranchManager chainBranchManager) {
        this.chainBranchManager = chainBranchManager;
    }
}

