/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.project;

import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.struts.Preparable;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;

public abstract class ProjectActionSupport
extends BambooActionSupport
implements Preparable {
    private String projectKey;
    private Project project;

    public void prepare() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.projectKey)) {
            this.addActionError(this.getText("project.configuration.error.project.key.missing"));
        } else {
            this.fetchProject();
            if (this.project == null) {
                this.addActionError(this.getText("project.configuration.error.project.not.found", Collections.singletonList(this.projectKey)));
            }
        }
    }

    public Project getSecuredDomainObject() {
        return this.getProject();
    }

    private void fetchProject() {
        if (StringUtils.isNotBlank((CharSequence)this.projectKey)) {
            this.project = this.projectManager.getProjectByKey(this.projectKey);
        }
    }

    public Project getProject() {
        if (this.project == null) {
            this.fetchProject();
        }
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public boolean isProjectWithPlans() {
        return !this.projectManager.getEmptyProjects().contains(this.project);
    }
}

