/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.project;

import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectConfigurationService;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.ww2.actions.project.ProjectActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.ProjectAdminSecurityAware;
import org.springframework.beans.factory.annotation.Autowired;

public class EditProjectDetails
extends ProjectActionSupport
implements ProjectAdminSecurityAware {
    private static final String PROJECT_NAME = "projectName";
    private static final String PROJECT_DESCRIPTION = "projectDescription";
    private String projectName;
    private String projectDescription;
    private boolean saved;
    @Autowired
    private ProjectConfigurationService projectConfigurationService;

    public String input() {
        if (this.hasAnyErrors()) {
            return "error";
        }
        if (this.isSaved()) {
            this.addActionMessage(this.getText("project.configuration.details.update.success"));
        }
        Project project = this.getProject();
        this.setProjectName(project.getName());
        this.setProjectDescription(project.getDescription());
        return "input";
    }

    public String execute() {
        if (this.hasAnyErrors()) {
            return "error";
        }
        ErrorCollection errors = this.projectConfigurationService.validateProjectForUpdate(this.getProjectKey(), PROJECT_NAME, this.projectName, PROJECT_DESCRIPTION, this.projectDescription);
        this.addErrorCollection(errors);
        if (this.hasAnyErrors()) {
            return "error";
        }
        try {
            this.projectConfigurationService.updateProject(this.getProject(), this.projectName, this.projectDescription);
            return "success";
        }
        catch (WebValidationException e) {
            this.addErrorCollection(e.getErrorCollection());
            return "error";
        }
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public void setProjectDescription(String projectDescription) {
        this.projectDescription = projectDescription;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }
}

