/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.project;

import com.atlassian.bamboo.project.ProjectPlanPermissionsService;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.utils.BambooCollectors;
import com.atlassian.bamboo.ww2.actions.project.ProjectActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.ProjectAdminSecurityAware;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.acegisecurity.acls.Permission;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class EditPlanPermissions
extends ProjectActionSupport
implements ProjectAdminSecurityAware {
    private static final Map<BambooPermission, String> PERMISSION_LABELS = ImmutableMap.of((Object)BambooPermission.READ, (Object)"build.permissions.type.view.heading", (Object)BambooPermission.WRITE, (Object)"build.permissions.type.edit.heading", (Object)BambooPermission.BUILD, (Object)"build.permissions.type.build.heading", (Object)BambooPermission.CLONE, (Object)"build.permissions.type.clone.heading", (Object)BambooPermission.ADMINISTRATION, (Object)"build.permissions.type.admin.heading");
    @Autowired
    private ProjectPlanPermissionsService projectPlanPermissionsService;

    @NotNull
    public Map<String, String> getEditablePermissions() {
        return (Map)this.projectPlanPermissionsService.supportedPermissions().stream().collect(BambooCollectors.toImmutableMap(PERMISSION_LABELS::get, BambooPermission::getName));
    }

    @NotNull
    public List<String> getPermissionDependencies(@NotNull String permissionName) {
        Permission permission = BambooPermission.buildFromName((String)permissionName);
        Preconditions.checkState((boolean)(permission instanceof BambooPermission));
        return this.projectPlanPermissionsService.permissionDependencies((BambooPermission)permission).stream().map(BambooPermission::getName).collect(Collectors.toList());
    }
}

