/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.project;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.host.spi.EntityReference;
import com.atlassian.bamboo.ww2.actions.project.DecoratedApplicationLink;
import com.atlassian.core.i18n.I18nTextProvider;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DecoratedEntityReference
implements Comparable<DecoratedEntityReference> {
    private static final Logger log = Logger.getLogger(DecoratedEntityReference.class);
    private final DecoratedApplicationLink applicationLink;
    private final String key;
    private final String name;
    private final String compositeKey;
    private final String displayName;

    private DecoratedEntityReference(@NotNull I18nTextProvider i18nTextProvider, @NotNull ApplicationLink applicationLink, @NotNull EntityReference entityReference) {
        this.applicationLink = new DecoratedApplicationLink(i18nTextProvider, applicationLink);
        this.key = entityReference.getKey();
        this.name = entityReference.getName();
        this.compositeKey = applicationLink.getId().get() + ":" + entityReference.getKey();
        this.displayName = String.format("%s (%s)", entityReference.getName(), entityReference.getKey());
    }

    private DecoratedEntityReference(@NotNull I18nTextProvider i18nTextProvider, @NotNull EntityLink entityLink) {
        this.applicationLink = new DecoratedApplicationLink(i18nTextProvider, entityLink.getApplicationLink());
        this.key = entityLink.getKey();
        this.name = entityLink.getName();
        this.compositeKey = entityLink.getApplicationLink().getId().get() + ":" + entityLink.getName();
        this.displayName = String.format("%s (%s)", entityLink.getName(), entityLink.getKey());
    }

    @Override
    public int compareTo(DecoratedEntityReference o) {
        return new CompareToBuilder().append((Object)this.getApplicationLink(), (Object)o.getApplicationLink()).append((Object)this.getDisplayName(), (Object)o.getDisplayName()).toComparison();
    }

    public boolean equals(Object o) {
        if (o instanceof DecoratedEntityReference) {
            DecoratedEntityReference rhs = (DecoratedEntityReference)o;
            return new EqualsBuilder().append((Object)this.getApplicationLink(), (Object)rhs.getApplicationLink()).append((Object)this.getKey(), (Object)rhs.getKey()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getApplicationLink()).append((Object)this.getKey()).toHashCode();
    }

    public static Function<EntityReference, DecoratedEntityReference> fromEntityReference(@NotNull I18nTextProvider i18nTextProvider, @NotNull ApplicationLink applicationLink) {
        return entityReference -> new DecoratedEntityReference(i18nTextProvider, applicationLink, (EntityReference)Preconditions.checkNotNull((Object)entityReference));
    }

    public static Function<Map.Entry<ApplicationLink, EntityReference>, DecoratedEntityReference> fromEntityReferenceMap(@NotNull I18nTextProvider i18nTextProvider) {
        return entry -> new DecoratedEntityReference(i18nTextProvider, (ApplicationLink)((Map.Entry)Preconditions.checkNotNull((Object)entry)).getKey(), (EntityReference)((Map.Entry)Preconditions.checkNotNull((Object)entry)).getValue());
    }

    public static Function<EntityLink, DecoratedEntityReference> fromEntityLink(@NotNull I18nTextProvider i18nTextProvider) {
        return entityLink -> new DecoratedEntityReference(i18nTextProvider, (EntityLink)Preconditions.checkNotNull((Object)entityLink));
    }

    public DecoratedApplicationLink getApplicationLink() {
        return this.applicationLink;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getCompositeKey() {
        return this.compositeKey;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

