/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.project;

import com.atlassian.applinks.api.EntityLink;
import com.atlassian.bamboo.ww2.actions.project.DecoratedApplicationLink;
import com.atlassian.bamboo.ww2.common.JsonHelper;
import com.atlassian.core.i18n.I18nTextProvider;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class DecoratedEntityLink
implements Comparable<DecoratedEntityLink> {
    private static final Logger log = Logger.getLogger(DecoratedEntityLink.class);
    private final DecoratedApplicationLink applicationLink;
    private final String key;
    private final String name;
    private final String displayName;
    private final String displayUrl;
    private final String iconUrl;
    private final String id;

    public DecoratedEntityLink(@NotNull I18nTextProvider i18nTextProvider, @NotNull EntityLink entityLink) {
        this.applicationLink = new DecoratedApplicationLink(i18nTextProvider, entityLink.getApplicationLink());
        this.key = entityLink.getKey();
        this.name = entityLink.getName();
        this.displayName = String.format("%s (%s)", entityLink.getName(), entityLink.getKey());
        this.displayUrl = entityLink.getDisplayUrl().toString();
        this.iconUrl = entityLink.getType().getIconUrl().toString();
        this.id = String.format("%s:%s", this.getApplicationLink().getId(), entityLink.getKey());
    }

    @Override
    public int compareTo(DecoratedEntityLink o) {
        return new CompareToBuilder().append((Object)this.getApplicationLink(), (Object)o.getApplicationLink()).append((Object)this.getDisplayName(), (Object)o.getDisplayName()).toComparison();
    }

    public static Function<EntityLink, DecoratedEntityLink> fromEntityLink(final @NotNull I18nTextProvider i18nTextProvider) {
        return new Function<EntityLink, DecoratedEntityLink>(){

            public DecoratedEntityLink apply(@Nullable EntityLink entityLink) {
                return new DecoratedEntityLink(i18nTextProvider, (EntityLink)Preconditions.checkNotNull((Object)entityLink));
            }
        };
    }

    @NotNull
    public JSONObject getJson() throws JSONException {
        return JsonHelper.buildJsonObject((Object)this, "id", "name", "key", "displayName", "displayUrl", "iconUrl").put("applicationLink", (Object)this.applicationLink.getJson());
    }

    public DecoratedApplicationLink getApplicationLink() {
        return this.applicationLink;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayUrl() {
        return this.displayUrl;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public String getId() {
        return this.id;
    }
}

