/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.project;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.bamboo.ww2.actions.project.DecoratedApplicationType;
import com.atlassian.bamboo.ww2.common.JsonHelper;
import com.atlassian.core.i18n.I18nTextProvider;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DecoratedApplicationLink
implements Comparable<DecoratedApplicationLink> {
    private static final Logger log = Logger.getLogger(DecoratedApplicationLink.class);
    private final String id;
    private final DecoratedApplicationType type;
    private final String displayName;
    private final String displayUrl;

    public DecoratedApplicationLink(@NotNull I18nTextProvider i18nTextProvider, @NotNull ApplicationLink applicationLink) {
        this.id = applicationLink.getId().get();
        this.type = new DecoratedApplicationType(i18nTextProvider, applicationLink.getType());
        this.displayName = String.format("%s (%s)", applicationLink.getName(), applicationLink.getDisplayUrl());
        this.displayUrl = applicationLink.getDisplayUrl().toString();
    }

    @Override
    public int compareTo(DecoratedApplicationLink o) {
        return new CompareToBuilder().append((Object)this.getDisplayName(), (Object)o.getDisplayName()).toComparison();
    }

    public boolean equals(Object o) {
        if (o instanceof DecoratedApplicationLink) {
            DecoratedApplicationLink rhs = (DecoratedApplicationLink)o;
            return new EqualsBuilder().append((Object)this.getId(), (Object)rhs.getId()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getId()).toHashCode();
    }

    @NotNull
    public JSONObject getJson() throws JSONException {
        return JsonHelper.buildJsonObject((Object)this, "id", "displayName", "displayUrl").put("type", (Object)this.type.getJson());
    }

    public String getId() {
        return this.id;
    }

    public DecoratedApplicationType getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayUrl() {
        return this.displayUrl;
    }
}

