/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.plans.admin;

import com.atlassian.bamboo.build.PlanDependency;
import com.atlassian.bamboo.build.PlanDependencyManager;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.plugin.web.PlanConfigurationUIPluginHelper;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.configuration.DependenciesBuildConfigurationPlugin;
import com.atlassian.bamboo.v2.build.trigger.DependencyBlockingStrategy;
import com.atlassian.bamboo.ww2.actions.build.admin.BuildConfigurationSupport;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.opensymphony.webwork.dispatcher.json.JSONArray;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ConfigurePlanDependencies
extends BuildConfigurationSupport
implements PlanEditSecurityAware {
    private static final Logger log = Logger.getLogger(ConfigurePlanDependencies.class);
    private boolean saved;
    private Set<String> childPlanKeys;
    private Set<String> parentPlanKeys;
    private Set<PlanDependency> childPlans;
    private Set<PlanDependency> parentPlans;
    private Set<String> disabledChildKeys;
    private Set<String> disabledParentKeys;
    private Collection<ImmutableTopLevelPlan> possiblePlanDependencies;
    private PlanDependencyManager planDependencyManager;
    private PlanConfigurationUIPluginHelper planConfigurationUIPluginHelper;

    public void validate() {
        this.resetDeselectedLists();
        if (CollectionUtils.containsAny(this.getChildPlanKeys(), this.getParentPlanKeys())) {
            this.addActionError(this.getText("chain.dependency.error.circular.dependencies"));
        }
        BuildConfiguration config = this.getBuildConfiguration();
        for (DependenciesBuildConfigurationPlugin plugin : this.getDependenciesBuildConfigurationPluginsForPlan(this.getMutablePlan())) {
            plugin.prepareConfigObject(config);
            ErrorCollection errorCollection = plugin.validate(config);
            if (errorCollection == null || !errorCollection.hasAnyErrors()) continue;
            this.addErrorCollection(errorCollection);
        }
        for (String childPlanKey : this.getChildPlanKeys()) {
            if (PlanKeys.isPlanKey((String)childPlanKey)) continue;
            this.addFieldError("childPlanKeys", this.getText("chain.dependency.error.invalid.key", Collections.singletonList(childPlanKey)));
        }
        Set childKeys = this.getChildPlanKeys().stream().map(planKey -> {
            try {
                return PlanKeys.getPlanKey((String)planKey);
            }
            catch (Exception e) {
                log.debug((Object)e.getMessage());
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        this.addErrorCollection(this.planDependencyManager.validateChildDependencyList("atlassian.dependency.default", this.getMutablePlan(), childKeys, false));
    }

    @Override
    public String doDefault() throws Exception {
        BuildConfiguration config = this.getBuildConfiguration();
        for (DependenciesBuildConfigurationPlugin plugin : this.getDependenciesBuildConfigurationPluginsForPlan(this.getMutablePlan())) {
            if (!plugin.isConfigurationMissing(config)) continue;
            plugin.addDefaultValues(config);
        }
        this.setDefaultDependencyBlockingStrategy();
        return "input";
    }

    @RssConfigurationAware
    public String create() throws Exception {
        this.resetDeselectedLists();
        Set childPlanKeys = this.getChildPlanKeys().stream().map(PlanKeys::getPlanKey).collect(Collectors.toSet());
        this.planDependencyManager.adjustChildDependencyList("atlassian.dependency.default", this.getMutablePlan(), childPlanKeys, false);
        return this.savePlan();
    }

    @NotNull
    public Iterable<DependenciesBuildConfigurationPlugin> getDependenciesBuildConfigurationPluginsForPlan(Plan plan) {
        return this.planConfigurationUIPluginHelper.getBuildConfigurationPlugins(plan, DependenciesBuildConfigurationPlugin.class);
    }

    @NotNull
    public String getDependenciesBuildConfigurationEditHtml() {
        return this.planConfigurationUIPluginHelper.getEditHtml(this.getBuildConfiguration(), this.getMutablePlan(), DependenciesBuildConfigurationPlugin.class);
    }

    protected void resetDeselectedLists() {
        if (this.areCheckBoxesEmpty("childPlanKeys")) {
            this.childPlanKeys = new HashSet<String>();
        }
    }

    public Set<String> getDisabledChildKeys() {
        if (this.disabledChildKeys == null) {
            this.disabledChildKeys = this.planDependencyManager.getNotEditableChildKeys((PlanIdentifier)this.getImmutablePlan());
        }
        return this.disabledChildKeys;
    }

    public Set<String> getDisabledParentKeys() {
        if (this.disabledParentKeys == null) {
            this.disabledParentKeys = this.planDependencyManager.getNotEditableParentKeys((PlanIdentifier)this.getImmutablePlan());
        }
        return this.disabledParentKeys;
    }

    @NotNull
    private Set<String> getChildPlanKeys() {
        if (this.childPlanKeys == null) {
            this.childPlanKeys = this.planDependencyManager.getChildPlanKeys((PlanIdentifier)this.getImmutablePlan());
        }
        return this.childPlanKeys;
    }

    public void setChildPlanKeys(Set<String> childPlanKeys) {
        this.childPlanKeys = childPlanKeys != null ? childPlanKeys.stream().filter(StringUtils::isNotEmpty).collect(Collectors.toSet()) : null;
    }

    @NotNull
    public Set<String> getParentPlanKeys() {
        if (this.parentPlanKeys == null) {
            this.parentPlanKeys = this.planDependencyManager.getParentPlanKeys((PlanIdentifier)this.getImmutablePlan());
        }
        return this.parentPlanKeys;
    }

    public final void setPlanDependencyManager(PlanDependencyManager planDependencyManager) {
        this.planDependencyManager = planDependencyManager;
    }

    public Collection<ImmutableTopLevelPlan> getPossiblePlanDependencies() {
        if (this.possiblePlanDependencies == null) {
            this.possiblePlanDependencies = this.cachedPlanManager.getPlans(ImmutableTopLevelPlan.class).stream().sorted(Comparators.getTopLevelPlanNameProviderCaseInsensitiveOrdering()).collect(Collectors.toCollection(ArrayList::new));
            if (this.getImmutablePlan() instanceof TopLevelPlan) {
                this.possiblePlanDependencies.remove(this.getImmutablePlan());
            }
        }
        return this.possiblePlanDependencies;
    }

    public List<DependencyBlockingStrategy> getDependencyBlockingStrategies() {
        return Arrays.asList(DependencyBlockingStrategy.values());
    }

    public void setDefaultDependencyBlockingStrategy() {
        String dbs = (String)this.getBuildConfiguration().getProperty("custom.dependencies.trigger.remote.strategy");
        if (StringUtils.isEmpty((CharSequence)dbs)) {
            this.getBuildConfiguration().setProperty("custom.dependencies.trigger.remote.strategy", (Object)DependencyBlockingStrategy.None);
        }
    }

    @Override
    public boolean isSaved() {
        return this.saved;
    }

    @Override
    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public void setPlanConfigurationUIPluginHelper(PlanConfigurationUIPluginHelper planConfigurationUIPluginHelper) {
        this.planConfigurationUIPluginHelper = planConfigurationUIPluginHelper;
    }

    public Set<PlanDependency> getChildPlans() {
        if (this.childPlans == null) {
            this.childPlans = this.planDependencyManager.getChildPlanDependencies((PlanIdentifier)this.getImmutablePlan());
        }
        return this.childPlans;
    }

    public Set<PlanDependency> getParentPlans() {
        if (this.parentPlans == null) {
            this.parentPlans = this.planDependencyManager.getParentPlanDependencies((PlanIdentifier)this.getImmutablePlan());
        }
        return this.parentPlans;
    }

    public JSONArray getChildPlansJson() throws JSONException {
        JSONArray jsonArray = new JSONArray();
        for (PlanDependency planDependency : this.getChildPlans()) {
            jsonArray.put((Object)this.makePlanJson(planDependency.getChildPlan(), planDependency.isEditable()));
        }
        return jsonArray;
    }

    public JSONArray getParentPlansJson() throws JSONException {
        JSONArray jsonArray = new JSONArray();
        for (PlanDependency planDependency : this.getParentPlans()) {
            jsonArray.put((Object)this.makePlanJson(planDependency.getParentPlan(), planDependency.isEditable()));
        }
        return jsonArray;
    }

    private JSONObject makePlanJson(Plan plan, boolean editable) throws JSONException {
        return new JSONObject().put("id", (Object)plan.getKey().toString()).put("projectName", (Object)plan.getProject().getName()).put("isEditable", editable).put("planName", (Object)plan.getBuildName());
    }
}

