/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.plans;

import com.atlassian.bamboo.agent.elastic.server.ElasticConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentService;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentServiceHelper;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.plan.ExecutableAgentsHelper;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.v2.build.agent.capability.MinimalRequirementSet;
import com.atlassian.core.i18n.I18nTextProvider;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AgentAvailabilityHintHelper {
    private static final Logger log = Logger.getLogger(AgentAvailabilityHintHelper.class);

    private AgentAvailabilityHintHelper() {
    }

    @Nullable
    public static String getAgentUnavailabilityHint(@NotNull ExecutableAgentsHelper executableAgentsHelper, @NotNull ElasticFunctionalityFacade elasticFunctionalityFacade, @NotNull AdministrationConfigurationAccessor administrationConfigurationAccessor, @NotNull I18nTextProvider textProvider, @NotNull ImmutableJob job, boolean assumeInstanceForEveryImage) {
        boolean hasExecutableImages;
        boolean includeDisabledAgents = false;
        if (executableAgentsHelper.planHasExecutableAgents(job.getPlanKey(), includeDisabledAgents)) {
            return null;
        }
        ExecutableAgentsHelper.ExecutorQuery executorQuery = ExecutableAgentsHelper.ExecutorQuery.newQuery((MinimalRequirementSet)job.getEffectiveRequirementSet(), (AgentAssignmentService.AgentAssignmentExecutable)AgentAssignmentServiceHelper.asExecutable((ImmutableBuildable)job)).withDisabledIncluded();
        boolean bl = hasExecutableImages = !executableAgentsHelper.getExecutableImages(executorQuery).isEmpty();
        if (hasExecutableImages && (assumeInstanceForEveryImage || AgentAvailabilityHintHelper.isElasticManagementEnabled(elasticFunctionalityFacade, administrationConfigurationAccessor))) {
            return null;
        }
        boolean hasExecutableDisabledAgents = executableAgentsHelper.planHasExecutableAgents(job.getPlanKey(), true);
        if (hasExecutableDisabledAgents && hasExecutableImages) {
            return textProvider.getText("queue.status.cantBuild.allDisabled");
        }
        if (hasExecutableDisabledAgents && !hasExecutableImages) {
            return textProvider.getText("queue.status.cantBuild.local");
        }
        if (hasExecutableImages) {
            return textProvider.getText("queue.status.cantBuild.elastic");
        }
        return textProvider.getText("queue.status.cantBuild");
    }

    private static boolean isElasticManagementEnabled(ElasticFunctionalityFacade elasticFunctionalityFacade, AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        ElasticConfiguration elasticConfig = administrationConfigurationAccessor.getAdministrationConfiguration().getElasticConfig();
        return elasticFunctionalityFacade.isElasticSupportEnabled() && elasticConfig != null && elasticConfig.getAutomaticInstanceManagementConfig().isAutomaticInstanceManagementEnabled();
    }
}

