/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.plan;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.deletion.DeletionService;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.event.analytics.PlanConfigurationChangedAnalyticsEvent;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionsFunctions;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.ww2.actions.PlanActionSupport;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanAdminSecurityAware;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DeletePlan
extends PlanActionSupport
implements PlanAdminSecurityAware {
    private static final Logger log = Logger.getLogger(DeletePlan.class);
    private ArtifactSubscriptionManager artifactSubscriptionManager;
    private DeletionService deletionService;
    @Inject
    private DeploymentProjectService deploymentProjectService;
    @Inject
    private EventPublisher eventPublisher;

    @RssConfigurationAware(blockJobsOnly=true)
    public String doDelete() {
        ImmutablePlan plan = this.getImmutablePlan();
        if (plan != null) {
            if (plan.isActive()) {
                this.addActionError(this.getText("plan.delete.active"));
                return "error";
            }
            this.deletionService.deletePlan(plan);
            this.eventPublisher.publish((Object)new PlanConfigurationChangedAnalyticsEvent());
            return "success";
        }
        this.addActionError("Can not delete this plan. It does not exist.  Plan Key: " + this.getPlanKey());
        return "error";
    }

    @Override
    @NotNull
    protected JSONObject buildJsonObject() throws JSONException {
        return super.buildJsonObject().put("plan", (Object)new JSONObject().put("key", (Object)this.getMutablePlan().getKey()));
    }

    @NotNull
    public Multimap<ChainStage, Job> getJobsContainingInvalidSubscriptions() {
        Job job = (Job)Narrow.to((Object)this.getMutablePlan(), Job.class);
        if (job != null) {
            List invalidSubscriptionsToJob = this.artifactSubscriptionManager.findCurrentSubscriptionsForPlan((ImmutableJob)job);
            Chain chain = job.getParent();
            TreeMultimap result = TreeMultimap.create((Comparator)Ordering.explicit((List)chain.getStages()), (Comparator)Comparators.getNameProviderCaseInsensitiveOrdering());
            for (Job job1 : Sets.newHashSet((Iterable)Iterables.transform((Iterable)invalidSubscriptionsToJob, ArtifactSubscriptionsFunctions::getConsumerJob))) {
                result.put((Object)job1.getStage(), (Object)job1);
            }
            return result;
        }
        return TreeMultimap.create((Comparator)Ordering.explicit((List)((Chain)this.getMutablePlan()).getStages()), (Comparator)Comparators.getNameProviderCaseInsensitiveOrdering());
    }

    public int getNumberOfChainBranches() {
        ImmutableChain immutableChain = (ImmutableChain)Narrow.downTo((Object)this.getImmutablePlan(), ImmutableChain.class);
        if (immutableChain == null) {
            return 0;
        }
        return this.cachedPlanManager.getBranchesForChain((PlanIdentifier)immutableChain).size();
    }

    public List<DeploymentProject> getLinkedDeploymentProjects() {
        return this.deploymentProjectService.getDeploymentProjectsRelatedToPlan(this.getImmutablePlan().getPlanKey());
    }

    public int getNumberOfExecutions(PlanKey planKey) {
        return this.planExecutionManager.numberOfExecutions(planKey);
    }

    public void setArtifactSubscriptionManager(ArtifactSubscriptionManager artifactSubscriptionManager) {
        this.artifactSubscriptionManager = artifactSubscriptionManager;
    }

    public void setDeletionService(DeletionService deletionService) {
        this.deletionService = deletionService;
    }
}

