/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.labels;

import com.atlassian.bamboo.labels.LabelCount;
import com.atlassian.bamboo.labels.LabelManager;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectDao;
import com.atlassian.bamboo.security.GlobalApplicationSecureObject;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.ww2.actions.PlanActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.PlanReadSecurityAware;
import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class ViewLabels
extends PlanActionSupport
implements PlanReadSecurityAware {
    private Map<Integer, List<LabelCount>> freqMap;
    private Map<LabelCount, Integer> results;
    Project project;
    LabelManager labelManager;
    ProjectDao projectDao;
    String projectKey;
    boolean orderByRank = false;
    private static float[] bucketBorders = new float[]{0.01f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f};

    public String execute() throws Exception {
        this.results = new TreeMap<LabelCount, Integer>(this.isOrderByRank() ? Comparators.getLabelCountRankComparator() : Comparators.getLabelCountAlphabeticComparator());
        for (Map.Entry<Integer, List<LabelCount>> entry : this.getBuckets().entrySet()) {
            Integer bucketIndex = entry.getKey();
            for (LabelCount labelCount : entry.getValue()) {
                this.results.put(labelCount, bucketIndex);
            }
        }
        return "success";
    }

    private Map<Integer, List<LabelCount>> getFreqMap() {
        if (this.freqMap == null) {
            this.freqMap = new TreeMap<Integer, List<LabelCount>>();
            for (LabelCount labelCount : this.getLabelCounts()) {
                int count = labelCount.getCount();
                List<LabelCount> labelCountList = this.freqMap.get(count);
                if (labelCountList == null) {
                    this.freqMap.put(count, new LinkedList<LabelCount>(Collections.singleton(labelCount)));
                    continue;
                }
                labelCountList.add(labelCount);
            }
        }
        return this.freqMap;
    }

    private Map<Integer, List<LabelCount>> getBuckets() {
        int bucket = 1;
        int cumulativeSum = 0;
        int totalSize = 0;
        for (Integer frequency : this.getFreqMap().keySet()) {
            totalSize += frequency.intValue();
        }
        TreeMap<Integer, List<LabelCount>> buckets = new TreeMap<Integer, List<LabelCount>>();
        for (Map.Entry<Integer, List<LabelCount>> entry : this.getFreqMap().entrySet()) {
            float bucketBorder;
            Integer frequency = entry.getKey();
            List<LabelCount> freqValues = entry.getValue();
            float currentPosition = (float)(cumulativeSum += frequency.intValue()) / (float)totalSize;
            for (int i = 0; i < bucketBorders.length && currentPosition > (bucketBorder = bucketBorders[i]); ++i) {
                bucket = i + 1;
            }
            List bucketValues = (List)buckets.get(bucket);
            if (bucketValues == null) {
                buckets.put(bucket, new LinkedList<LabelCount>(freqValues));
            } else {
                bucketValues.addAll(freqValues);
            }
            bucket = 1;
        }
        return buckets;
    }

    private List<LabelCount> getLabelCounts() {
        return this.labelManager.findLabels("label", 200, this.getMutablePlan(), this.getProject());
    }

    public boolean isOrderByRank() {
        return this.orderByRank;
    }

    public void setOrderByRank(boolean orderByRank) {
        this.orderByRank = orderByRank;
    }

    public Map getResults() {
        return this.results;
    }

    public void setResults(Map results) {
        this.results = results;
    }

    @Override
    public Project getProject() {
        if (this.project == null) {
            if (this.getImmutablePlan() != null) {
                this.project = this.getImmutablePlan().getProject();
            } else if (StringUtils.isNotBlank((CharSequence)this.projectKey)) {
                this.project = this.projectDao.getProjectByKey(this.projectKey);
            }
        }
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public void setProjectDao(ProjectDao projectDao) {
        this.projectDao = projectDao;
    }

    @Override
    public Object getSecuredDomainObject() {
        return MoreObjects.firstNonNull((Object)this.getImmutablePlan(), (Object)GlobalApplicationSecureObject.INSTANCE);
    }
}

