/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.labels;

import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanFavouriteService;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.ww2.actions.BuildActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.PlanReadSecurityAware;
import org.apache.log4j.Logger;

public class SetFavouriteAction
extends BuildActionSupport
implements PlanReadSecurityAware {
    private static final Logger log = Logger.getLogger(SetFavouriteAction.class);
    PlanFavouriteService planFavouriteService;
    private Boolean favourite;

    public String execute() throws Exception {
        if (this.getImmutablePlan() == null) {
            this.addActionError("Could not find the \"" + this.getPlanKey() + "\" plan");
            return "error";
        }
        this.planFavouriteService.toggleFavourite(this.getMutablePlan(), this.getUser());
        return "success";
    }

    public String view() throws Exception {
        return "input";
    }

    private boolean isFavourite() {
        if (this.favourite == null) {
            this.favourite = this.planFavouriteService.isFavourite((ImmutablePlan)this.getMutablePlan(), this.getUser());
        }
        return this.favourite;
    }

    public boolean isFavourite(Plan plan) {
        return this.planFavouriteService.isFavourite((ImmutablePlan)plan, this.getUser());
    }

    public void setPlanFavouriteService(PlanFavouriteService planFavouriteService) {
        this.planFavouriteService = planFavouriteService;
    }
}

