/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.labels;

import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.labels.LabelManager;
import com.atlassian.bamboo.labels.LabelParser;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.util.ActionParamsUtils;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.bamboo.ww2.actions.PlanActionSupport;
import com.atlassian.bamboo.ww2.aware.ResultsSummaryAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanReadSecurityAware;
import java.util.List;
import org.acegisecurity.acls.Permission;

public class EditLabelsAction
extends PlanActionSupport
implements ResultsSummaryAware,
PlanReadSecurityAware {
    private LabelManager labelManager;
    private List<Label> labels;
    private String labelInput;
    private String selectedLabel;
    private ResultsSummary resultsSummary;
    private static final String BUILD_NUMBER = "buildNumber";

    @Override
    public String doDefault() throws Exception {
        return "input";
    }

    public void validate() {
        if (this.getResultsSummary() == null && this.getImmutablePlan() == null) {
            this.addActionError(this.getText("labels.error.no.plan"));
        }
    }

    public String addLabels() throws Exception {
        List labels = LabelParser.split((String)this.getLabelInput());
        ImmutablePlan plan = this.getImmutablePlan();
        if (this.buildNumber != null) {
            if (!this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.READ, plan.getPlanKey())) {
                this.addActionError(this.getText("labels.error.cannot.add") + " " + this.getTextWithArgs("labels.error.details.missing.view.permission", plan.getName()));
            }
        } else {
            if (!this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.WRITE, plan.getPlanKey())) {
                this.addActionError(this.getText("labels.error.cannot.add") + " " + this.getTextWithArgs("labels.error.details.missing.edit.permission", plan.getName()));
            }
            if (this.getImmutableMasterChain(plan).getVcsBambooSpecsSource() != null) {
                this.addActionError(this.getText("labels.error.cannot.add") + " " + this.getText("labels.error.details.rss.managed.plan"));
            }
        }
        for (String label : labels) {
            boolean validLabel = LabelParser.isValidLabelName((String)label);
            if (validLabel) continue;
            this.addFieldError("labelInput", this.getTextWithArgs("labels.error.details.invalid.character", BambooStringUtils.encodeHtmlWithTagWhiteList((String)label), LabelParser.getFirstInvalidLabelCharacter((String)label)));
        }
        if (this.hasAnyErrors()) {
            return "error";
        }
        if (this.resultsSummary != null && ActionParamsUtils.hasParameter(BUILD_NUMBER)) {
            for (String label : labels) {
                this.labelManager.addLabel(label, this.resultsSummary.getPlanResultKey(), this.getUser());
            }
        } else {
            boolean change = this.labelManager.addLabels(labels, plan.getPlanKey(), this.getUser());
            if (change) {
                this.setPlan(this.cachedPlanManager.getPlanByKey(plan.getPlanKey()));
            }
        }
        return "success";
    }

    public String deleteLabel() throws Exception {
        ImmutablePlan plan = this.getImmutablePlan();
        if (this.featureManager.isRemovingLabelsAndCommentsAllowedForNonPlanAdmin()) {
            if (this.resultsSummary == null && !this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.READ, plan.getPlanKey())) {
                this.addActionError(this.getText("labels.error.cannot.delete") + " " + this.getTextWithArgs("labels.error.details.missing.view.permission", plan.getName()));
            }
        } else if (!this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.WRITE, plan.getPlanKey())) {
            this.addActionError(this.getText("labels.error.cannot.delete") + " " + this.getTextWithArgs("labels.error.details.missing.edit.permission", plan.getName()));
        }
        if (this.getSelectedLabel() == null) {
            this.addActionError(this.getText("labels.error.details.not.found"));
        }
        if (this.buildNumber == null && this.getImmutableMasterChain(plan).getVcsBambooSpecsSource() != null) {
            this.addActionError(this.getText("labels.error.cannot.delete") + " " + this.getText("labels.error.details.rss.managed.plan"));
        }
        if (this.hasAnyErrors()) {
            return "error";
        }
        if (this.resultsSummary != null && ActionParamsUtils.hasParameter(BUILD_NUMBER)) {
            this.labelManager.removeLabel(this.getSelectedLabel(), this.resultsSummary.getPlanResultKey(), this.getUser());
        } else {
            this.labelManager.removeLabel(this.getSelectedLabel(), plan.getPlanKey(), this.getUser());
            this.setPlan((ImmutablePlan)this.planManager.getPlanByKey(plan.getPlanKey()));
        }
        return "success";
    }

    private ImmutableChain getImmutableMasterChain(ImmutablePlan plan) {
        ImmutableChain chain;
        ImmutableChain immutableChain = chain = plan instanceof ImmutableJob ? ((ImmutableJob)plan).getParent() : (ImmutableChain)plan;
        if (chain.hasMaster()) {
            chain = chain.getMaster();
        }
        return chain;
    }

    public String getLabelInput() {
        return this.labelInput;
    }

    public void setLabelInput(String labelInput) {
        this.labelInput = labelInput;
    }

    public List<Label> getLabels() {
        List labellings;
        if (this.labels == null && this.getResultsSummary() != null && ActionParamsUtils.hasParameter(BUILD_NUMBER) && (labellings = this.getResultsSummary().getLabellings()) != null) {
            this.labels = LabelParser.extractLabelsFromLabellings((List)labellings);
        }
        return this.labels;
    }

    public void setLabels(List<Label> labels) {
        this.labels = labels;
    }

    public String getSelectedLabel() {
        return this.selectedLabel;
    }

    public void setSelectedLabel(String selectedLabel) {
        this.selectedLabel = selectedLabel;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    @Override
    public ResultsSummary getResultsSummary() {
        return this.resultsSummary;
    }

    @Override
    public void setResultsSummary(ResultsSummary resultsSummary) {
        this.resultsSummary = resultsSummary;
    }
}

