/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.jira;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.bamboo.applinks.CredentialsRequiredContextException;
import com.atlassian.bamboo.jira.jiraissues.JiraIssuePredicates;
import com.atlassian.bamboo.jira.jiraissues.JiraRemoteIssueManager;
import com.atlassian.bamboo.jira.rest.JiraRestResponse;
import com.atlassian.bamboo.jira.rest.JiraRestService;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.actions.jira.AbstractJiraIssueAction;
import com.atlassian.sal.api.net.Request;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.net.URI;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class TransitionJiraIssueAction
extends AbstractJiraIssueAction {
    private static final Logger log = Logger.getLogger(TransitionJiraIssueAction.class);
    @Autowired
    private JiraRemoteIssueManager jiraRemoteIssueManager;
    @Autowired
    private JiraRestService jiraRestService;
    private String issueKey;
    private String transitionId;
    private String resolutionId;
    private JSONObject response;

    @Override
    @NotNull
    public JSONObject getJsonObject() throws JSONException {
        if (this.response == null) {
            this.response = this.buildJsonObject();
        }
        if (this.issueKey != null) {
            String projectKey = JiraIssuePredicates.getJiraProjectKey((String)this.issueKey);
            try {
                ApplicationLink applicationLink = this.jiraRemoteIssueManager.getJiraApplicationLink(projectKey, null);
                if (applicationLink != null) {
                    this.response.put("issueUrl", (Object)(applicationLink.getDisplayUrl() + "/browse/" + this.issueKey));
                }
            }
            catch (Exception e) {
                log.warn((Object)"unable to retrieve the issue url", (Throwable)e);
            }
        }
        return this.response;
    }

    public String execute() throws Exception {
        String projectKey = JiraIssuePredicates.getJiraProjectKey((String)this.issueKey);
        try {
            try {
                JiraRestResponse jiraResponse;
                ApplicationLink applicationLink = this.jiraRemoteIssueManager.getJiraApplicationLink(projectKey, null);
                if (applicationLink == null) {
                    this.addActionError("Unable to find application link for the supplied parameters.");
                    return "error";
                }
                if (this.resolutionId == null) {
                    JiraRestResponse jiraResponse2 = this.jiraRestService.doRestCallViaApplink(applicationLink, "rest/api/latest/issue/" + this.issueKey + "/transitions?expand=transitions.fields&transitionId=" + this.transitionId, Request.MethodType.GET, null);
                    if (jiraResponse2.hasErrors()) {
                        this.copyErrorsToAction(jiraResponse2);
                        return "error";
                    }
                    if (jiraResponse2.entity != null) {
                        try {
                            JSONObject resolution = jiraResponse2.entity.getJSONArray("transitions").getJSONObject(0).getJSONObject("fields").getJSONObject("resolution");
                            if (resolution != null) {
                                this.response = this.buildJsonObject().put("resolution", (Object)resolution).put("requireResolution", true);
                                return "success";
                            }
                        }
                        catch (JSONException resolution) {
                            // empty catch block
                        }
                    }
                }
                JSONObject data = new JSONObject().put("transition", (Object)new JSONObject().put("id", (Object)this.transitionId));
                if (this.resolutionId != null) {
                    data.put("fields", (Object)new JSONObject().put("resolution", (Object)new JSONObject().put("id", (Object)this.resolutionId)));
                }
                if ((jiraResponse = this.jiraRestService.doRestCallViaApplink(applicationLink, "rest/api/latest/issue/" + this.issueKey + "/transitions", Request.MethodType.POST, data)).hasErrors()) {
                    this.copyErrorsToAction(jiraResponse);
                    return "error";
                }
                if (jiraResponse.entity != null) {
                    this.response = jiraResponse.entity;
                } else {
                    this.addActionMessage("It looks like the transition completed successfully.  But response received from Jira is not what we expected. Please confirm the operation yourself");
                }
                return "success";
            }
            catch (CredentialsRequiredContextException e) {
                return this.handleCredentialsRequiredException(e);
            }
        }
        catch (Exception e) {
            return this.reportError(e);
        }
    }

    private String reportError(Exception e) {
        String errorMsg = "Error while fetching issue information from Jira: ";
        this.addActionError("Error while fetching issue information from Jira: " + e);
        log.error((Object)"Error while fetching issue information from Jira: ", (Throwable)e);
        return "error";
    }

    private String handleCredentialsRequiredException(CredentialsRequiredContextException cre) throws Exception {
        this.response = new JSONObject().put("status", (Object)BambooActionSupport.JSONStatus.ERROR).put("authenticationInstanceName", (Object)cre.getContext()).put("authenticationRedirectUrl", (Object)cre.getAuthorisationURI(URI.create(this.getBaseUrl() + this.getReturnUrl())));
        return "error";
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public void setIssueKey(String issueKey) {
        this.issueKey = issueKey;
    }

    public String getTransitionId() {
        return this.transitionId;
    }

    public void setTransitionId(String transitionId) {
        this.transitionId = transitionId;
    }

    public String getResolutionId() {
        return this.resolutionId;
    }

    public void setResolutionId(String resolutionId) {
        this.resolutionId = resolutionId;
    }
}

