/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.jira;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.bamboo.applinks.CredentialsRequiredContextException;
import com.atlassian.bamboo.applinks.JiraApplinksService;
import com.atlassian.bamboo.build.PlanResultsAction;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueDetails;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueLinkType;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueManager;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssueImpl;
import com.atlassian.bamboo.jira.jirametadata.JiraStatus;
import com.atlassian.bamboo.jira.jirametadata.JiraType;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestsManager;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.collect.Iterables;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class LinkTestToJiraIssueAction
extends PlanResultsAction {
    private static final Logger log = Logger.getLogger(LinkTestToJiraIssueAction.class);
    private LinkedJiraIssue linkedJiraIssue;
    private long testCaseId = -1L;
    private CredentialsRequiredContextException credentialsRequiredContextException;
    private String manualIssueKey;
    @Autowired
    private TestsManager testsManager;
    @Autowired
    private JiraApplinksService jiraApplinksService;
    @Autowired
    private JiraIssueManager jiraIssueManager;

    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.manualIssueKey)) {
            this.addFieldError("manualIssueKey", "Please provide non-empty issue key.");
        }
        if (this.testsManager.getTestCaseById(this.testCaseId) == null) {
            this.addActionError("Could not find testCase for id = " + this.testCaseId);
        }
    }

    public String execute() {
        this.manualIssueKey = StringUtils.upperCase((String)this.manualIssueKey);
        this.manualIssueKey = StringUtils.trim((String)this.manualIssueKey);
        this.linkedJiraIssue = new LinkedJiraIssueImpl(this.manualIssueKey, JiraIssueLinkType.BUILD_RELATES);
        try {
            ApplicationLink primaryApplicationLink = (ApplicationLink)Iterables.getFirst((Iterable)this.jiraApplinksService.getJiraApplicationLinks(), null);
            if (primaryApplicationLink != null) {
                JiraIssueDetails details = this.jiraIssueManager.getJiraIssueDetails(this.getImmutablePlan().getProject(), this.manualIssueKey);
                if (details.getSummary() == null && details.getType() == null && details.getStatus() == null) {
                    this.addFieldError("manualIssueKey", "Issue not found - either it doesn't exist or you do not have permission to see it.");
                    return "error";
                }
                this.linkedJiraIssue.setJiraIssueDetails(details);
            }
        }
        catch (IllegalArgumentException e) {
            this.addFieldError("manualIssueKey", "Please provide valid Jira issue key.");
            return "error";
        }
        catch (CredentialsRequiredContextException e) {
            this.credentialsRequiredContextException = e;
        }
        catch (ResponseException e) {
            this.addActionError("Could not retrieve Jira issue - check your connection to Jira.");
            return "error";
        }
        TestCase testCase = this.testsManager.getTestCaseById(this.testCaseId);
        testCase.setLinkedJiraIssueKey(this.manualIssueKey);
        this.testsManager.saveTestCase(testCase);
        return "success";
    }

    @NotNull
    public static JSONObject buildLinkedJiraIssueJson(@NotNull LinkedJiraIssue linkedJiraIssue) throws JSONException {
        JSONObject issue = new JSONObject().put("key", (Object)linkedJiraIssue.getIssueKey());
        JiraIssueDetails jiraIssueDetails = linkedJiraIssue.getJiraIssueDetails();
        if (jiraIssueDetails != null) {
            JiraStatus jiraStatus;
            issue.put("url", (Object)jiraIssueDetails.getDisplayUrl());
            issue.put("summary", (Object)jiraIssueDetails.getSummary());
            JiraType jiraType = jiraIssueDetails.getType();
            if (jiraType != null) {
                issue.put("issueType", (Object)jiraType.getTypeDescription());
                issue.put("iconUrl", (Object)jiraType.getTypeIconUrl());
            }
            if ((jiraStatus = jiraIssueDetails.getStatus()) != null) {
                issue.put("status", (Object)jiraStatus.getStatusDescription());
            }
        }
        return issue;
    }

    @Override
    @NotNull
    public JSONObject buildJsonObject() throws JSONException {
        JSONObject jsonObject = super.buildJsonObject();
        if (this.credentialsRequiredContextException != null) {
            jsonObject.put("authenticationInstanceName", (Object)this.credentialsRequiredContextException.getContext());
            jsonObject.put("authenticationRedirectUrl", (Object)this.credentialsRequiredContextException.getAuthorisationURI());
        }
        if (this.linkedJiraIssue != null) {
            jsonObject.put("issue", (Object)LinkTestToJiraIssueAction.buildLinkedJiraIssueJson(this.linkedJiraIssue));
        }
        if (this.testCaseId != -1L) {
            jsonObject.put("testCaseId", this.testCaseId);
        }
        return jsonObject;
    }

    public long getTestCaseId() {
        return this.testCaseId;
    }

    public void setTestCaseId(long testCaseId) {
        this.testCaseId = testCaseId;
    }

    public void setManualIssueKey(String manualIssueKey) {
        this.manualIssueKey = manualIssueKey;
    }

    public String getManualIssueKey() {
        return this.manualIssueKey;
    }
}

