/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.jira;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.bamboo.applinks.CredentialsRequiredContextException;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueKey;
import com.atlassian.bamboo.jira.jiraissues.JiraIssuePredicates;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueUtils;
import com.atlassian.bamboo.jira.jiraissues.JiraRemoteIssueManager;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.sal.api.net.ResponseException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class JiraRedirectAction
extends BambooActionSupport {
    private static final Logger log = Logger.getLogger(JiraRedirectAction.class);
    private String jiraIssueKey;
    private String bambooProjectKey;
    private JiraRemoteIssueManager jiraRemoteIssueManager;
    private String jiraProjectKey;
    private URI jiraUrl;
    private URI credentialsRequiredUrl;
    private Project bambooProject;

    public String execute() throws Exception {
        this.validateParameters();
        if (this.hasActionErrors()) {
            return "error";
        }
        try {
            ApplicationLink applicationLink = this.jiraRemoteIssueManager.getJiraApplicationLink(this.jiraProjectKey, this.bambooProject);
            if (applicationLink != null) {
                this.jiraUrl = applicationLink.getDisplayUrl();
                return "success";
            }
            this.addActionError("Unable to find application link for the supplied parameters.");
            return "error";
        }
        catch (CredentialsRequiredContextException e) {
            return this.handleCredentialsRequiredException(e);
        }
        catch (ResponseException e) {
            return this.reportError((Exception)((Object)e));
        }
    }

    private String handleCredentialsRequiredException(CredentialsRequiredContextException e) throws URISyntaxException {
        String url = this.getBaseUrl() + this.getCurrentUrl();
        URI callback = null;
        try {
            callback = new URI(url);
        }
        catch (URISyntaxException uriSyntaxException) {
            log.warn((Object)"Cannot establish current URL", (Throwable)uriSyntaxException);
        }
        this.credentialsRequiredUrl = e.getAuthorisationURI(callback);
        if (this.credentialsRequiredUrl != null) {
            log.debug((Object)("User needs to supply credentials to access Jira, redirecting to: " + this.credentialsRequiredUrl + " , return URL :" + url));
            return "input";
        }
        return this.reportError((Exception)((Object)e));
    }

    private String reportError(Exception e) {
        String errorMsg = "Error while fetching issue information from Jira: ";
        this.addActionError("Error while fetching issue information from Jira: " + e);
        log.error((Object)"Error while fetching issue information from Jira: ", (Throwable)e);
        return "error";
    }

    private void validateParameters() {
        if (StringUtils.isBlank((CharSequence)this.jiraIssueKey)) {
            this.addActionError("jiraIssueKey must not be empty.");
        } else {
            try {
                this.jiraProjectKey = JiraIssuePredicates.getJiraProjectKey((String)this.jiraIssueKey);
            }
            catch (RuntimeException e) {
                this.addActionError("Invalid Jira project key: " + e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.bambooProjectKey)) {
            this.bambooProject = this.projectManager.getProjectByKey(this.bambooProjectKey);
            if (this.bambooProject == null) {
                this.addActionError("Invalid Bamboo project key: " + this.bambooProjectKey);
            }
        }
    }

    public void setJiraIssueKey(String jiraIssueKey) {
        this.jiraIssueKey = jiraIssueKey;
    }

    public void setBambooProjectKey(String bambooProjectKey) {
        this.bambooProjectKey = bambooProjectKey;
    }

    public String getJiraIssueUrl() {
        return JiraIssueUtils.getJiraIssueUrl((String)this.jiraUrl.toString(), (JiraIssueKey)new JiraIssueKey(this.jiraIssueKey), null);
    }

    public String getCredentialsRequiredUrl() {
        return this.credentialsRequiredUrl.toString();
    }

    public void setJiraRemoteIssueManager(JiraRemoteIssueManager jiraRemoteIssueManager) {
        this.jiraRemoteIssueManager = jiraRemoteIssueManager;
    }
}

