/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.jira;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.bamboo.applinks.CredentialsRequiredContextException;
import com.atlassian.bamboo.jira.jiraissues.JiraIssuePredicates;
import com.atlassian.bamboo.jira.jiraissues.JiraRemoteIssueManager;
import com.atlassian.bamboo.jira.rest.JiraRestResponse;
import com.atlassian.bamboo.jira.rest.JiraRestService;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.actions.jira.AbstractJiraIssueAction;
import com.atlassian.sal.api.net.Request;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.net.URI;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class GetJiraIssueSchemaAction
extends AbstractJiraIssueAction {
    private static final Logger log = Logger.getLogger(GetJiraIssueSchemaAction.class);
    @Autowired
    private JiraRemoteIssueManager jiraRemoteIssueManager;
    @Autowired
    private JiraRestService jiraRestService;
    private JSONObject response;
    private String projectKey;
    private String issueTypeId;
    private String issueKey;

    @Override
    @NotNull
    public JSONObject getJsonObject() throws JSONException {
        if (this.response == null) {
            this.response = this.buildJsonObject();
        }
        return this.response;
    }

    public String execute() {
        return this.executeRestCall("rest/api/latest/issue/createmeta");
    }

    public String issueTypeSchema() {
        return this.executeRestCall("rest/api/latest/issue/createmeta?expand=projects.issuetypes.fields&projectKeys=" + this.projectKey + "&issuetypeIds=" + this.issueTypeId);
    }

    public String issueTransitions() {
        return this.executeIssueRestCall("rest/api/latest/issue/" + this.issueKey + "/transitions?expand=transitions.fields");
    }

    public String issueDetails() {
        return this.executeIssueRestCall("rest/api/latest/issue/" + this.issueKey + "?fields=summary,status,issuetype");
    }

    private String executeIssueRestCall(String requestUrl) {
        String projectKey = JiraIssuePredicates.getJiraProjectKey((String)this.issueKey);
        try {
            try {
                ApplicationLink applicationLink = this.jiraRemoteIssueManager.getJiraApplicationLink(projectKey, null);
                return this.executeRestCall(requestUrl, applicationLink);
            }
            catch (CredentialsRequiredContextException e) {
                return this.handleCredentialsRequiredException(e);
            }
        }
        catch (Exception e) {
            return this.reportError(e);
        }
    }

    private String executeRestCall(String requestUrl) {
        return this.executeRestCall(requestUrl, this.getSelectedJiraApplicationLink());
    }

    private String executeRestCall(String requestUrl, ApplicationLink applicationLink) {
        try {
            if (applicationLink == null) {
                this.addActionError("Unable to find application link for the supplied parameters.");
                return "error";
            }
            try {
                JiraRestResponse restResponse = this.jiraRestService.doRestCallViaApplink(applicationLink, requestUrl, Request.MethodType.GET, null);
                if (restResponse.hasErrors()) {
                    this.copyErrorsToAction(restResponse);
                    return "error";
                }
                if (restResponse.entity == null) {
                    this.addActionError("Failed to read required data from Jira Response.");
                    return "error";
                }
                this.response = restResponse.entity;
                return "success";
            }
            catch (CredentialsRequiredContextException cre) {
                return this.handleCredentialsRequiredException(cre, this.getBambooUrl().withBaseUrlFromRequest(this.getReturnUrl()) + "&createIssueAppLinkId=" + applicationLink.getId());
            }
        }
        catch (Exception e) {
            return this.reportError(e);
        }
    }

    private String reportError(Exception e) {
        String errorMsg = "Error while fetching issue information from Jira: ";
        this.addActionError("Error while fetching issue information from Jira: " + e);
        log.error((Object)"Error while fetching issue information from Jira: ", (Throwable)e);
        return "error";
    }

    private String handleCredentialsRequiredException(CredentialsRequiredContextException cre) throws Exception {
        return this.handleCredentialsRequiredException(cre, this.getBaseUrl() + this.getReturnUrl());
    }

    private String handleCredentialsRequiredException(CredentialsRequiredContextException cre, @NotNull String returnUrl) throws Exception {
        this.response = new JSONObject().put("status", (Object)BambooActionSupport.JSONStatus.ERROR).put("authenticationInstanceName", (Object)cre.getContext()).put("authenticationRedirectUrl", (Object)cre.getAuthorisationURI(URI.create(returnUrl)));
        return "error";
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public String getIssueTypeId() {
        return this.issueTypeId;
    }

    public void setIssueTypeId(String issueTypeId) {
        this.issueTypeId = issueTypeId;
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public void setIssueKey(String issueKey) {
        this.issueKey = issueKey;
    }
}

