/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.jira;

import com.atlassian.bamboo.applinks.CredentialsRequiredContextException;
import com.atlassian.bamboo.jira.issuelink.JiraBranchLinkingService;
import com.atlassian.bamboo.jira.issuelink.RemoteLinkCreationFailedException;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueDetails;
import com.atlassian.bamboo.jira.rest.Errors;
import com.atlassian.bamboo.jira.rest.JiraRestResponse;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.ww2.actions.PlanActionSupport;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CreateRemoteJiraLinkAction
extends PlanActionSupport {
    private static final Logger log = Logger.getLogger(CreateRemoteJiraLinkAction.class);
    private String issueKey;
    private CredentialsRequiredContextException credentialsRequiredContextException;
    private JiraBranchLinkingService jiraBranchLinkingService;

    public String execute() {
        if (StringUtils.isBlank((CharSequence)this.issueKey)) {
            this.addActionError("Could not add Remote Link to Jira, issue key not supplied");
            return "error";
        }
        ImmutablePlan plan = this.getImmutablePlan();
        if (plan == null) {
            this.addActionError("Could not add Remote Link to Jira, no plan to link to found");
            return "error";
        }
        ImmutableChainBranch chainBranch = (ImmutableChainBranch)Narrow.to((Object)plan, ImmutableChainBranch.class);
        if (chainBranch == null) {
            this.addActionError("Could not add Remote Link to Jira, only Branches are allowed to be linked");
            return "error";
        }
        try {
            JiraIssueDetails details = this.jiraBranchLinkingService.createRemoteLinkToBranch(chainBranch, this.issueKey);
            this.addActionMessage("Remote link successfully created");
            ChainBranch mutableBranch = (ChainBranch)this.planManager.getPlanByKey(chainBranch.getPlanKey(), ChainBranch.class);
            if (mutableBranch == null) {
                throw new IllegalStateException("Could not complete issue to branch linking operations.  Branch disappeared half way through the operation...");
            }
            mutableBranch.setRemoteJiraLinkRequired(false);
            mutableBranch.setDescription(details.getSummary());
            this.planManager.savePlan((Plan)mutableBranch);
            return "success";
        }
        catch (RemoteLinkCreationFailedException e) {
            this.addActionError((Exception)((Object)e));
            if (e.getResponse() != null && e.getResponse().hasErrors()) {
                this.copyErrorsToAction(e.getResponse());
            }
        }
        catch (CredentialsRequiredContextException e) {
            this.addActionError("Could not create Remote Issue Link. Authentication Required");
            this.credentialsRequiredContextException = e;
        }
        return "error";
    }

    @Override
    @NotNull
    public JSONObject getJsonObject() throws JSONException {
        JSONObject jsonObject = super.getJsonObject();
        if (this.credentialsRequiredContextException != null) {
            jsonObject.put("context", (Object)this.credentialsRequiredContextException.getContext()).put("message", (Object)this.credentialsRequiredContextException.getMessage()).put("authorisationURI", (Object)this.credentialsRequiredContextException.getAuthorisationURI());
        }
        return jsonObject;
    }

    protected void copyErrorsToAction(@NotNull JiraRestResponse response) {
        Errors errors = response.errors;
        if (errors != null) {
            this.addErrorMessages(errors.errorMessages);
            for (Map.Entry entry : errors.errors.entrySet()) {
                this.addActionError((String)entry.getKey() + ": " + (String)entry.getValue());
            }
        }
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public void setIssueKey(String issueKey) {
        this.issueKey = issueKey;
    }

    public void setJiraBranchLinkingService(JiraBranchLinkingService jiraBranchLinkingService) {
        this.jiraBranchLinkingService = jiraBranchLinkingService;
    }
}

