/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.jira;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueDetails;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueLinkType;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueManager;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssueImpl;
import com.atlassian.bamboo.jira.rest.JiraRestService;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestsManager;
import com.atlassian.bamboo.ww2.actions.jira.AbstractCreateNewJiraIssueAction;
import com.atlassian.bamboo.ww2.actions.jira.LinkTestToJiraIssueAction;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateNewJiraIssueForTestAction
extends AbstractCreateNewJiraIssueAction {
    @Autowired
    private TestsManager testsManager;
    @Autowired
    private JiraIssueManager jiraIssueManager;
    @Autowired
    private JiraRestService jiraRestService;
    private LinkedJiraIssue linkedJiraIssue;
    private long testCaseId = -1L;
    private TestCase testCase;

    @Override
    @NotNull
    protected JSONObject buildJsonObject() throws JSONException {
        JSONObject result = super.buildJsonObject();
        if (this.credentialsRequiredUrl == null && !this.hasActionErrors()) {
            if (this.linkedJiraIssue != null) {
                result.put("issue", (Object)LinkTestToJiraIssueAction.buildLinkedJiraIssueJson(this.linkedJiraIssue));
            }
            if (this.testCaseId != -1L) {
                result.put("testCaseId", this.testCaseId);
            }
        }
        return result;
    }

    public void validate() {
        this.testCase = this.testsManager.getTestCaseById(this.testCaseId);
        if (this.testsManager.getTestCaseById(this.testCaseId) == null) {
            this.addActionError("Could not find testCase for id = " + this.testCaseId);
        }
    }

    @Override
    public String execute() throws Exception {
        String result = super.execute();
        if ("success".equals(result)) {
            this.testCase.setLinkedJiraIssueKey(this.newIssueKey);
            this.testsManager.saveTestCase(this.testCase);
            JiraIssueDetails details = this.jiraIssueManager.getJiraIssueDetails(this.getResultsSummary().getImmutablePlan().getProject(), this.newIssueKey);
            this.linkedJiraIssue = new LinkedJiraIssueImpl(this.newIssueKey, JiraIssueLinkType.BUILD_RELATES);
            this.linkedJiraIssue.setJiraIssueDetails(details);
        }
        return result;
    }

    @Override
    protected JSONObject createIssueLinkData(@NotNull ApplicationLink applicationLink, @NotNull String issueKey, @NotNull ResultsSummary resultsSummary) throws Exception {
        return this.jiraRestService.getRemoteIssueLinkJson("testCaseId=" + this.testCase.getId() + "&planResultKey" + resultsSummary.getPlanResultKey(), this.testCase.getTestClass().getName() + " \u203a " + this.testCase.getName(), resultsSummary.getPlanResultKey().toString(), "Created from test", "/browse/" + resultsSummary.getPlanResultKey() + "#testCase-" + this.testCase.getId(), applicationLink.getRpcUrl() + this.convertBuildStateToIconFileName(resultsSummary));
    }

    public long getTestCaseId() {
        return this.testCaseId;
    }

    public void setTestCaseId(long testCaseId) {
        this.testCaseId = testCaseId;
    }
}

